/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.opennms.smoketest.containers.CassandraContainer;
import org.opennms.smoketest.containers.ElasticsearchContainer;
import org.opennms.smoketest.containers.JaegerContainer;
import org.opennms.smoketest.containers.LocalOpenNMS;
import org.opennms.smoketest.containers.MinionContainer;
import org.opennms.smoketest.containers.OpenNMSContainer;
import org.opennms.smoketest.containers.PostgreSQLContainer;
import org.opennms.smoketest.containers.SentinelContainer;
import org.opennms.smoketest.stacks.IpcStrategy;
import org.opennms.smoketest.stacks.MinionProfile;
import org.opennms.smoketest.stacks.OpenNMSProfile;
import org.opennms.smoketest.stacks.SentinelProfile;
import org.opennms.smoketest.stacks.StackModel;
import org.opennms.smoketest.stacks.TimeSeriesStrategy;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public final class OpenNMSStack
implements TestRule {
    public static final OpenNMSStack NONE = new OpenNMSStack();
    public static final OpenNMSStack MINIMAL = OpenNMSStack.withModel(StackModel.newBuilder().withOpenNMS(OpenNMSProfile.newBuilder().withFile("empty-discovery-configuration.xml", "etc/discovery-configuration.xml").build()).build());
    public static final OpenNMSStack MINIMAL_WITH_DEFAULT_LOCALHOST = OpenNMSStack.withModel(StackModel.newBuilder().build());
    public static final OpenNMSStack MINION = OpenNMSStack.withModel(StackModel.newBuilder().withMinion().build());
    public static final OpenNMSStack SENTINEL = OpenNMSStack.withModel(StackModel.newBuilder().withSentinel().build());
    public static final OpenNMSStack ALEC = OpenNMSStack.withModel(StackModel.newBuilder().withMinions(MinionProfile.DEFAULT, MinionProfile.newBuilder().withLocation("BANANA").build()).withSentinel().withElasticsearch().withIpcStrategy(IpcStrategy.KAFKA).build());
    private final TestRule delegateTestRule;
    private final PostgreSQLContainer postgreSQLContainer;
    private final JaegerContainer jaegerContainer;
    private final OpenNMSContainer opennmsContainer;
    private final KafkaContainer kafkaContainer;
    private final ElasticsearchContainer elasticsearchContainer;
    private final CassandraContainer cassandraContainer;
    private final List<MinionContainer> minionContainers;
    private final List<SentinelContainer> sentinelContainers;

    public static OpenNMSStack withModel(StackModel model) {
        return new OpenNMSStack(model);
    }

    private OpenNMSStack() {
        this.postgreSQLContainer = null;
        this.jaegerContainer = null;
        this.elasticsearchContainer = null;
        this.kafkaContainer = null;
        this.cassandraContainer = null;
        this.opennmsContainer = new LocalOpenNMS();
        this.minionContainers = Collections.EMPTY_LIST;
        this.sentinelContainers = Collections.EMPTY_LIST;
        this.delegateTestRule = RuleChain.emptyRuleChain();
    }

    private OpenNMSStack(StackModel model) {
        boolean shouldEnableKafka;
        this.postgreSQLContainer = new PostgreSQLContainer();
        RuleChain chain = RuleChain.outerRule((TestRule)this.postgreSQLContainer);
        if (model.isJaegerEnabled()) {
            this.jaegerContainer = new JaegerContainer();
            chain = chain.around((TestRule)this.jaegerContainer);
        } else {
            this.jaegerContainer = null;
        }
        if (model.isElasticsearchEnabled()) {
            this.elasticsearchContainer = new ElasticsearchContainer();
            chain = chain.around((TestRule)this.elasticsearchContainer);
        } else {
            this.elasticsearchContainer = null;
        }
        boolean bl = shouldEnableKafka = IpcStrategy.KAFKA.equals((Object)model.getIpcStrategy()) || model.getOpenNMS().isKafkaProducerEnabled();
        if (shouldEnableKafka) {
            this.kafkaContainer = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka:7.2.0")).withEnv("KAFKA_HEAP_OPTS", "-Xms256m -Xmx256m")).withNetwork(Network.SHARED)).withNetworkAliases(new String[]{"kafka"});
            chain = chain.around((TestRule)this.kafkaContainer);
        } else {
            this.kafkaContainer = null;
        }
        if (TimeSeriesStrategy.NEWTS.equals((Object)model.getTimeSeriesStrategy())) {
            this.cassandraContainer = new CassandraContainer();
            ((CassandraContainer)this.cassandraContainer.withNetwork(Network.SHARED)).withNetworkAliases(new String[]{"cassandra"});
            chain = chain.around((TestRule)this.cassandraContainer);
        } else {
            this.cassandraContainer = null;
        }
        this.opennmsContainer = new OpenNMSContainer(model, model.getOpenNMS());
        chain = chain.around((TestRule)this.opennmsContainer);
        ArrayList<MinionContainer> minions = new ArrayList<MinionContainer>(model.getMinions().size());
        for (MinionProfile profile : model.getMinions()) {
            MinionContainer minion = new MinionContainer(model, profile);
            minions.add(minion);
            chain = chain.around((TestRule)minion);
        }
        this.minionContainers = Collections.unmodifiableList(minions);
        ArrayList<SentinelContainer> sentinels = new ArrayList<SentinelContainer>(model.getSentinels().size());
        for (SentinelProfile profile : model.getSentinels()) {
            SentinelContainer sentinel = new SentinelContainer(model, profile);
            sentinels.add(sentinel);
            chain = chain.around((TestRule)sentinel);
        }
        this.sentinelContainers = Collections.unmodifiableList(sentinels);
        this.delegateTestRule = chain;
    }

    public OpenNMSContainer opennms() {
        return this.opennmsContainer;
    }

    public MinionContainer minion() {
        if (this.minionContainers.isEmpty()) {
            throw new IllegalStateException("Minion container is not enabled in this stack.");
        }
        return this.minionContainers.get(0);
    }

    public MinionContainer minions(int index) {
        return this.minionContainers.get(index);
    }

    public SentinelContainer sentinel() {
        if (this.sentinelContainers.isEmpty()) {
            throw new IllegalStateException("Sentinel container is not enabled in this stack.");
        }
        return this.sentinelContainers.get(0);
    }

    public SentinelContainer sentinels(int index) {
        return this.sentinelContainers.get(index);
    }

    public JaegerContainer jaeger() {
        if (this.jaegerContainer == null) {
            throw new IllegalStateException("Jaeger container is not enabled in this stack.");
        }
        return this.jaegerContainer;
    }

    public ElasticsearchContainer elastic() {
        if (this.elasticsearchContainer == null) {
            throw new IllegalStateException("Elasticsearch container is not enabled in this stack.");
        }
        return this.elasticsearchContainer;
    }

    public PostgreSQLContainer postgres() {
        return this.postgreSQLContainer;
    }

    public KafkaContainer kafka() {
        if (this.kafkaContainer == null) {
            throw new IllegalStateException("Kafka container is not enabled in this stack.");
        }
        return this.kafkaContainer;
    }

    public Statement apply(Statement base, Description description) {
        return this.delegateTestRule.apply(base, description);
    }
}

