/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import com.google.common.io.Resources;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opennms.smoketest.containers.OpenNMSContainer;
import org.opennms.smoketest.stacks.OverlayFile;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class OpenNMSProfile {
    public static OpenNMSProfile DEFAULT = OpenNMSProfile.newBuilder().build();
    private final boolean jvmDebuggingEnabled;
    private final boolean kafkaProducerEnabled;
    private final List<OverlayFile> files;
    private final Function<OpenNMSContainer, WaitStrategy> waitStrategy;

    private OpenNMSProfile(Builder builder) {
        this.jvmDebuggingEnabled = builder.jvmDebuggingEnabled;
        this.kafkaProducerEnabled = builder.kafkaProducerEnabled;
        this.files = Collections.unmodifiableList(builder.files);
        this.waitStrategy = Objects.requireNonNull(builder.waitStrategy);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isJvmDebuggingEnabled() {
        return this.jvmDebuggingEnabled;
    }

    public boolean isKafkaProducerEnabled() {
        return this.kafkaProducerEnabled;
    }

    public List<OverlayFile> getFiles() {
        return this.files;
    }

    public Function<OpenNMSContainer, WaitStrategy> getWaitStrategy() {
        return this.waitStrategy;
    }

    public static final class Builder {
        private boolean jvmDebuggingEnabled = false;
        private boolean kafkaProducerEnabled = false;
        private List<OverlayFile> files = new LinkedList<OverlayFile>();
        private Function<OpenNMSContainer, WaitStrategy> waitStrategy = OpenNMSContainer.WaitForOpenNMS::new;

        public Builder withJvmDebuggingEnabled(boolean enabled) {
            this.jvmDebuggingEnabled = enabled;
            return this;
        }

        public Builder withKafkaProducerEnabled(boolean enabled) {
            this.kafkaProducerEnabled = enabled;
            return this;
        }

        public Builder withFile(Path source, String target) {
            try {
                this.files.add(new OverlayFile(source.toUri().toURL(), target));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withFile(URL source, String target) {
            this.files.add(new OverlayFile(source, target));
            return this;
        }

        public Builder withFile(String resourceName, String target) {
            this.files.add(new OverlayFile(Resources.getResource((String)resourceName), target));
            return this;
        }

        public Builder withFile(URL source, String target, Set<PosixFilePermission> permissions) {
            this.files.add(new OverlayFile(source, target, permissions));
            return this;
        }

        public Builder withFile(String resourceName, String target, Set<PosixFilePermission> permissions) {
            this.files.add(new OverlayFile(Resources.getResource((String)resourceName), target, permissions));
            return this;
        }

        public Builder withWaitStrategy(Function<OpenNMSContainer, WaitStrategy> waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public OpenNMSProfile build() {
            return new OpenNMSProfile(this);
        }
    }
}

