/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.selenium;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.smoketest.selenium.AbstractOpenNMSSeleniumHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class AbstractPage {
    protected static final long SHORT_WAIT_SECONDS = 5L;
    protected static final long LONG_WAIT_SECONDS = 10L;
    protected final AbstractOpenNMSSeleniumHelper testCase;

    public AbstractPage(AbstractOpenNMSSeleniumHelper testCase) {
        this.testCase = Objects.requireNonNull(testCase);
    }

    protected WebDriver getDriver() {
        return this.testCase.getDriver();
    }

    protected void get(String path) {
        String fullURL = this.testCase.buildUrlInternal(path);
        this.getDriver().get(fullURL);
    }

    protected List<WebElement> findElements(By by) {
        try {
            this.testCase.setImplicitWait(10L, TimeUnit.SECONDS);
            List list = this.getDriver().findElements(by);
            return list;
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected WebElement findElement(By by) {
        try {
            this.testCase.setImplicitWait(5L, TimeUnit.SECONDS);
            WebElement webElement = this.getDriver().findElement(by);
            return webElement;
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected WebElement findElementByName(String name) {
        try {
            this.testCase.setImplicitWait(5L, TimeUnit.SECONDS);
            WebElement webElement = this.testCase.findElementByName(name);
            return webElement;
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected WebElement findElementByXpath(String xpath) {
        try {
            this.testCase.setImplicitWait(5L, TimeUnit.SECONDS);
            WebElement webElement = this.testCase.findElementByXpath(xpath);
            return webElement;
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected WebElement clickElement(By by) {
        try {
            this.testCase.setImplicitWait(5L, TimeUnit.SECONDS);
            WebElement webElement = this.testCase.clickElement(by);
            return webElement;
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected WebElement enterText(By by, String text) {
        return this.testCase.enterText(by, text);
    }

    protected void waitUntil(ExpectedCondition<Boolean> condition) {
        try {
            this.testCase.setImplicitWait(10L, TimeUnit.SECONDS);
            new WebDriverWait(this.getDriver(), Duration.ofSeconds(10L)).until(condition);
        }
        finally {
            this.testCase.setImplicitWait();
        }
    }

    protected ExpectedCondition<Boolean> pageContainsText(String text) {
        return this.testCase.pageContainsText(text);
    }
}

