/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import org.junit.Assert;
import org.opennms.smoketest.utils.KarafShell;
import org.opennms.smoketest.utils.SshClient;
import org.testcontainers.containers.Container;
import org.testcontainers.utility.MountableFile;

public interface KarafContainer<T extends KarafContainer<T>>
extends Container<T> {
    public SshClient ssh();

    public InetSocketAddress getSshAddress();

    public Path getKarafHomeDirectory();

    default public Path getKarafHotDeployDirectory() {
        return this.getKarafHomeDirectory().resolve("deploy");
    }

    default public void installFeature(String feature, Path kar, String ... preInstallConfig) {
        this.copyFileToContainer(MountableFile.forHostPath((Path)kar), this.getKarafHotDeployDirectory().resolve(kar.getFileName()).toString());
        this.installFeature(feature, preInstallConfig);
    }

    default public void installFeature(String feature, String ... preInstallConfig) {
        KarafShell karafShell = new KarafShell(this.getSshAddress());
        karafShell.runCommand("feature:list | grep " + feature, output -> output.contains(feature), false);
        for (String line : preInstallConfig) {
            Assert.assertTrue((boolean)karafShell.runCommandOnce(line, output -> !output.toLowerCase().contains("error"), false));
        }
        Assert.assertTrue((boolean)karafShell.runCommandOnce("feature:install " + feature, output -> !output.toLowerCase().contains("error"), false));
    }
}

