/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils;

import java.util.List;
import javax.ws.rs.core.Response;

public abstract class ResponseUtils {
    private ResponseUtils() {
    }

    public static <T> Response createResponse(List<T> entities, long offset, long totalCount) {
        if (entities == null || entities.isEmpty()) {
            return Response.noContent().build();
        }
        String contentRangeHeader = ResponseUtils.getContentRange(entities.size(), offset, totalCount);
        return Response.ok(entities).header("Content-Range", (Object)contentRangeHeader).build();
    }

    public static String getContentRange(long itemCount, long offset, long totalCount) {
        return String.format("items %d-%d/%d", offset, offset + itemCount - 1L, totalCount);
    }
}

