/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.xml.rtc.Node;
import org.opennms.web.category.AvailabilityNode;
import org.opennms.web.category.CategoryUtil;
import org.opennms.web.category.NodeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Category {
    private static final Logger LOG = LoggerFactory.getLogger(Category.class);
    protected final org.opennms.netmgt.config.categories.Category m_categoryDef;
    protected final org.opennms.netmgt.xml.rtc.Category m_rtcCategory;
    protected final Date m_lastUpdated;
    protected Long m_serviceCount;
    protected Long m_serviceDownCount;
    protected Double m_servicePercentage;

    protected Category() {
        this.m_categoryDef = new org.opennms.netmgt.config.categories.Category();
        this.m_rtcCategory = null;
        this.m_lastUpdated = null;
    }

    protected Category(String categoryName) {
        this.m_categoryDef = new org.opennms.netmgt.config.categories.Category();
        this.m_categoryDef.setLabel(categoryName);
        this.m_categoryDef.setNormalThreshold(Double.valueOf(0.0));
        this.m_categoryDef.setWarningThreshold(Double.valueOf(0.0));
        this.m_rtcCategory = null;
        this.m_lastUpdated = null;
    }

    protected Category(org.opennms.netmgt.config.categories.Category categoryDef, org.opennms.netmgt.xml.rtc.Category rtcCategory, Date lastUpdated) {
        if (categoryDef == null || rtcCategory == null || lastUpdated == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (categoryDef.getLabel() == null || !categoryDef.getLabel().equals(rtcCategory.getCatlabel())) {
            throw new IllegalArgumentException("Cannot take category definition and rtc category value whose names do not match.");
        }
        this.m_categoryDef = categoryDef;
        this.m_rtcCategory = rtcCategory;
        this.m_lastUpdated = lastUpdated;
        this.m_serviceCount = null;
        this.m_serviceDownCount = null;
        this.m_servicePercentage = null;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.m_categoryDef == null ? null : this.m_categoryDef.getLabel();
    }

    @XmlAttribute(name="normal-threshold")
    public double getNormalThreshold() {
        Double ret = this.m_categoryDef == null ? null : this.m_categoryDef.getNormalThreshold();
        return ret == null ? 0.0 : ret;
    }

    @XmlAttribute(name="warning-threshold")
    public double getWarningThreshold() {
        Double ret = this.m_categoryDef == null ? null : this.m_categoryDef.getWarningThreshold();
        return ret == null ? 0.0 : ret;
    }

    @XmlElement(name="comment")
    public String getComment() {
        return this.m_categoryDef == null ? null : (String)this.m_categoryDef.getComment().orElse(null);
    }

    @XmlElement(name="last-updated")
    public Date getLastUpdated() {
        return this.m_lastUpdated;
    }

    @XmlElement(name="availability")
    public double getValue() {
        if (this.m_rtcCategory == null) {
            return 0.0;
        }
        return this.m_rtcCategory.getCatvalue();
    }

    org.opennms.netmgt.xml.rtc.Category getRtcCategory() {
        return this.m_rtcCategory;
    }

    private synchronized long getServiceCount() {
        if (this.m_serviceCount == null) {
            if (this.m_rtcCategory == null) {
                this.m_serviceCount = 0L;
                this.m_serviceDownCount = 0L;
                this.m_servicePercentage = 0.0;
            } else {
                long[] counts = Category.getServiceCounts(this.m_rtcCategory);
                this.m_serviceCount = counts[0];
                this.m_serviceDownCount = counts[1];
                this.m_servicePercentage = this.m_serviceCount == 0L ? Double.valueOf(100.0) : Double.valueOf((double)(this.m_serviceCount - this.m_serviceDownCount) / (double)this.m_serviceCount.longValue() * 100.0);
            }
        }
        return this.m_serviceCount;
    }

    @XmlElement(name="service-down-count")
    public synchronized long getServiceDownCount() {
        if (this.m_serviceDownCount == null) {
            this.getServiceCount();
        }
        if (this.m_serviceDownCount == null) {
            LOG.warn("Could not fetch service down count for category: {}", (Object)this.m_rtcCategory.getCatlabel());
            return 0L;
        }
        return this.m_serviceDownCount;
    }

    @XmlElement(name="service-percentage")
    public synchronized double getServicePercentage() {
        if (this.m_servicePercentage == null) {
            this.getServiceCount();
        }
        if (this.m_servicePercentage == null) {
            LOG.warn("Could not fetch service percentage for category: {}", (Object)this.m_rtcCategory.getCatlabel());
            return 0.0;
        }
        return this.m_servicePercentage;
    }

    @XmlElement(name="outage-class")
    public String getOutageClass() throws IOException {
        if (this.m_lastUpdated == null) {
            return "Indeterminate";
        }
        return CategoryUtil.getCategoryClass(this, this.getServicePercentage());
    }

    @XmlElement(name="availability-class")
    public String getAvailClass() throws IOException {
        if (this.m_lastUpdated == null) {
            return "Indeterminate";
        }
        return CategoryUtil.getCategoryClass(this);
    }

    @XmlElement(name="outage-text")
    public String getOutageText() {
        if (this.m_lastUpdated == null) {
            return "Calculating...";
        }
        return this.getServiceDownCount() + " of " + this.getServiceCount();
    }

    @XmlElement(name="availability-text")
    public String getAvailText() {
        if (this.m_lastUpdated == null) {
            return "Calculating...";
        }
        return CategoryUtil.valueFormat.format(this.getValue()) + "%";
    }

    public String getTitle() {
        if (this.getComment() != null) {
            return this.getComment();
        }
        return this.getName();
    }

    @XmlElementWrapper(name="nodes")
    @XmlElement(name="node")
    public List<Long> getNodeIds() {
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        if (this.m_rtcCategory != null) {
            for (Node node : this.m_rtcCategory.getNode()) {
                nodeIds.add(node.getNodeid());
            }
        }
        return nodeIds;
    }

    public List<Node> getNode() {
        return this.m_rtcCategory.getNode();
    }

    public NodeList getNodes() {
        if (this.m_rtcCategory != null) {
            return NodeList.forNodes(this.m_rtcCategory.getNode());
        }
        return new NodeList();
    }

    public AvailabilityNode getNode(Long nodeId) {
        if (this.m_rtcCategory != null) {
            for (Node node : this.m_rtcCategory.getNode()) {
                if (node.getNodeid() != nodeId.longValue()) continue;
                return new AvailabilityNode(node);
            }
        }
        return null;
    }

    protected static long[] getServiceCounts(org.opennms.netmgt.xml.rtc.Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        long count = 0L;
        long downCount = 0L;
        for (Node node : category.getNode()) {
            count += node.getNodesvccount();
            downCount += node.getNodesvcdowncount();
        }
        return new long[]{count, downCount};
    }
}

