/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@WebFilter(asyncSupported=true, urlPatterns={"/*"})
public class SpaRoutingFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String uri = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        if (this.isClientPath(uri)) {
            chain.doFilter((ServletRequest)new HttpServletRequestWrapper(httpServletRequest){

                public String getServletPath() {
                    return "/ui/index.html";
                }
            }, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isClientPath(String uri) {
        return uri.startsWith("/ui/") && !uri.startsWith("/ui/assets/") && !uri.endsWith(".svg");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

