/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.BeanUtils;
import org.opennms.web.api.HtmlInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlInjectHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlInjectHandler.class);
    private static AtomicReference<ServiceRegistry> serviceRegistryRef = new AtomicReference();

    public static String inject(HttpServletRequest request) {
        ServiceRegistry serviceRegistry = serviceRegistryRef.updateAndGet(ref -> {
            if (ref == null) {
                return (ServiceRegistry)BeanUtils.getBean((String)"soaContext", (String)"serviceRegistry", ServiceRegistry.class);
            }
            return ref;
        });
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- Begin injected -->");
        for (HtmlInjector injector : serviceRegistry.findProviders(HtmlInjector.class)) {
            try {
                String content = injector.inject(request);
                if (content == null) continue;
                sb.append(content);
            }
            catch (Throwable t) {
                LOG.warn("Injector {} failed.", (Object)injector, (Object)t);
            }
        }
        sb.append("<!-- End injected -->\n");
        return sb.toString();
    }
}

