/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils;

import java.util.Objects;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.web.utils.QueryParameters;

public class CriteriaBuilderUtils {
    public static CriteriaBuilder buildFrom(Class<?> clazz, QueryParameters queryParameters) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(queryParameters);
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(clazz);
        CriteriaBuilderUtils.applyQueryParameters(criteriaBuilder, queryParameters);
        return criteriaBuilder;
    }

    public static void applyQueryParameters(CriteriaBuilder builder, QueryParameters queryParameters) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(queryParameters);
        builder.limit(queryParameters.getLimit());
        if (queryParameters.getOffset() != null) {
            builder.offset(queryParameters.getOffset());
        }
        if (queryParameters.getOrder() != null) {
            builder.clearOrder();
            builder.orderBy(queryParameters.getOrder().getColumn(), !queryParameters.getOrder().isDesc());
        }
    }
}

