/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.springframework.validation.Errors;

public class LocationMonitorListModel {
    private Errors m_errors;
    private List<LocationMonitorModel> m_locationMonitors;

    public List<LocationMonitorModel> getLocationMonitors() {
        return this.m_locationMonitors;
    }

    public void setLocationMonitors(List<LocationMonitorModel> locationMonitors) {
        this.m_locationMonitors = locationMonitors;
    }

    public void addLocationMonitor(LocationMonitorModel locationMonitor) {
        if (this.m_locationMonitors == null) {
            this.m_locationMonitors = new LinkedList<LocationMonitorModel>();
        }
        this.m_locationMonitors.add(locationMonitor);
    }

    public Errors getErrors() {
        return this.m_errors;
    }

    public void setErrors(Errors errors) {
        this.m_errors = errors;
    }

    public static class LocationMonitorModel {
        private String m_area;
        private String m_definitionName;
        private String m_id;
        private String m_name;
        private String m_hostName;
        private String m_ipAddress;
        private String m_connectionHostName;
        private String m_connectionIpAddress;
        private Date m_lastCheckInTime;
        private Map<String, String> m_additionalDetails;

        public LocationMonitorModel() {
        }

        public LocationMonitorModel(OnmsMonitoringLocation def) {
            if (def == null) {
                throw new IllegalArgumentException("def argument cannot be null");
            }
            if (def != null && def.getMonitoringArea() != null) {
                this.setArea(def.getMonitoringArea());
            }
            this.setDefinitionName(def.getLocationName());
        }

        public Map<String, String> getAdditionalDetails() {
            return this.m_additionalDetails;
        }

        public void setAdditionalDetails(Map<String, String> additionalDetails) {
            this.m_additionalDetails = additionalDetails;
        }

        public void addAdditionalDetail(String key, String value) {
            if (this.m_additionalDetails == null) {
                this.m_additionalDetails = new LinkedHashMap<String, String>();
            }
            this.m_additionalDetails.put(key, value);
        }

        public String getArea() {
            return this.m_area;
        }

        public void setArea(String area) {
            this.m_area = area;
        }

        public String getDefinitionName() {
            return this.m_definitionName;
        }

        public void setDefinitionName(String definitionName) {
            this.m_definitionName = definitionName;
        }

        public String getHostName() {
            return this.m_hostName;
        }

        public void setHostName(String hostName) {
            this.m_hostName = hostName;
        }

        public String getConnectionHostName() {
            return this.m_connectionHostName;
        }

        public void setConnectionHostName(String hostName) {
            this.m_connectionHostName = hostName;
        }

        public String getId() {
            return this.m_id;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public String getIpAddress() {
            return this.m_ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.m_ipAddress = ipAddress;
        }

        public String getConnectionIpAddress() {
            return this.m_connectionIpAddress;
        }

        public void setConnectionIpAddress(String ipAddress) {
            this.m_connectionIpAddress = ipAddress;
        }

        public Date getLastCheckInTime() {
            return this.m_lastCheckInTime;
        }

        public void setLastCheckInTime(Date lastcheckInTime) {
            this.m_lastCheckInTime = lastcheckInTime;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }
    }
}

