/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.RelaxedX509ExtendedTrustManager;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.support.AsyncBasicDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureFailedImpl;
import org.opennms.netmgt.provision.support.DetectFutureNettyImpl;
import org.opennms.netmgt.provision.support.DetectorHandlerNettyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBasicDetectorNettyImpl<Request, Response>
extends AsyncBasicDetector<Request, Response> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBasicDetectorNettyImpl.class);
    private static final ChannelFactory m_factory = new NioClientSocketChannelFactory((Executor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new LogPreservingThreadFactory("AsyncBasicDetectorNettyImpl.boss", Integer.MAX_VALUE)), (Executor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new LogPreservingThreadFactory("AsyncBasicDetectorNettyImpl.worker", Integer.MAX_VALUE)));

    public AsyncBasicDetectorNettyImpl(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetectorNettyImpl(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    @Override
    public void dispose() {
        LOG.debug("calling dispose on detector {}", (Object)this.getServiceName());
        m_factory.releaseExternalResources();
    }

    @Override
    public final DetectFuture isServiceDetected(InetAddress address) {
        DetectFuture detectFuture = new DetectFutureFailedImpl(this, new IllegalStateException());
        try {
            ClientBootstrap bootstrap = new ClientBootstrap(m_factory);
            bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline retval = Channels.pipeline();
                    AsyncBasicDetectorNettyImpl.this.appendToPipeline(retval);
                    retval.addLast("detectorHandler", AsyncBasicDetectorNettyImpl.this.getDetectorHandler(AsyncBasicDetectorNettyImpl.this.getConversation()));
                    if (AsyncBasicDetectorNettyImpl.this.isUseSSLFilter()) {
                        retval.addLast("sslHandler", (ChannelHandler)new SslHandler(AsyncBasicDetectorNettyImpl.createClientSSLContext().createSSLEngine()));
                    }
                    return retval;
                }
            });
            bootstrap.setOption("tcpNoDelay", (Object)true);
            bootstrap.setOption("keepAlive", (Object)true);
            InetSocketAddress remoteAddress = new InetSocketAddress(address, this.getPort());
            ChannelFuture future = bootstrap.connect((SocketAddress)remoteAddress);
            future.addListener((ChannelFutureListener)new RetryChannelFutureListener(remoteAddress, this.getRetries()));
            detectFuture = new DetectFutureNettyImpl(this, future);
        }
        catch (Throwable e) {
            detectFuture = new DetectFutureFailedImpl(this, e);
        }
        return detectFuture;
    }

    protected void appendToPipeline(ChannelPipeline retval) {
    }

    protected DetectorHandlerNettyImpl<Request, Response> getDetectorHandler(AsyncClientConversation<Request, Response> conversation) {
        DetectorHandlerNettyImpl<Request, Response> handler = new DetectorHandlerNettyImpl<Request, Response>();
        handler.setConversation(conversation);
        return handler;
    }

    private static SSLContext createClientSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509ExtendedTrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        return sslContext;
    }

    private class RetryChannelFutureListener
    implements ChannelFutureListener {
        private final SocketAddress m_remoteAddress;
        private int m_retries;

        public RetryChannelFutureListener(SocketAddress remoteAddress, int retries) {
            this.m_remoteAddress = remoteAddress;
            this.m_retries = retries;
        }

        public void operationComplete(ChannelFuture future) {
            Throwable cause = future.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    if (this.m_retries == 0) {
                        LOG.info("Service {} detected false", (Object)AsyncBasicDetectorNettyImpl.this.getServiceName());
                        future.setFailure((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                    } else {
                        LOG.info("Connection exception occurred {} for service {}, retrying attempt {}", new Object[]{cause, AsyncBasicDetectorNettyImpl.this.getServiceName(), this.m_retries});
                        InetSocketAddress localAddress = new InetSocketAddress(InetAddressUtils.getLocalHostAddress(), 0);
                        future.removeListener((ChannelFutureListener)this);
                        LOG.error("RETRIES {}", (Object)this.m_retries);
                        future.addListener((ChannelFutureListener)new RetryChannelFutureListener(this.m_remoteAddress, this.m_retries - 1));
                        future.getChannel().bind((SocketAddress)localAddress);
                        future.getChannel().connect(this.m_remoteAddress);
                    }
                } else {
                    LOG.info("Threw a Throwable and detection is false for service {}", (Object)AsyncBasicDetectorNettyImpl.this.getServiceName(), (Object)cause);
                    future.setFailure((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                }
            }
        }
    }
}

