/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import org.opennms.netmgt.model.OnmsSeverity;

public class HeatMapElement {
    private String name;
    private int id;
    private int nodesUp;
    private int nodesTotal;
    private int servicesDown;
    private int servicesTotal;
    private int maximumSeverity;
    private Type type;

    public HeatMapElement(String name, Number id, Number servicesDown, Number servicesTotal, Number nodesUp, Number nodesTotal) {
        this.name = name == null ? "Uncategorized" : name;
        this.id = id == null ? -1 : id.intValue();
        this.servicesDown = servicesDown == null ? 0 : servicesDown.intValue();
        this.servicesTotal = servicesTotal == null ? 0 : servicesTotal.intValue();
        this.nodesUp = nodesUp == null ? 0 : nodesUp.intValue();
        this.nodesTotal = nodesTotal == null ? 0 : nodesTotal.intValue();
        this.type = Type.Outage;
    }

    public HeatMapElement(String name, Number id, Number servicesTotal, Number nodesTotal, Number maximumSeverity) {
        this.name = name == null ? "Uncategorized" : name;
        this.id = id == null ? -1 : id.intValue();
        this.servicesTotal = servicesTotal == null ? 0 : servicesTotal.intValue();
        this.nodesTotal = nodesTotal == null ? 0 : nodesTotal.intValue();
        this.maximumSeverity = maximumSeverity == null ? 0 : maximumSeverity.intValue();
        this.type = Type.Alarm;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getNodesUp() {
        return this.nodesUp;
    }

    public int getNodesDown() {
        return this.getNodesTotal() - this.getNodesUp();
    }

    public int getNodesTotal() {
        return this.nodesTotal;
    }

    public int getServicesUp() {
        return this.getServicesTotal() - this.getServicesDown();
    }

    public int getServicesDown() {
        return this.servicesDown;
    }

    public int getServicesTotal() {
        return this.servicesTotal;
    }

    public int getMaximumSeverity() {
        return this.maximumSeverity;
    }

    public Type getType() {
        return this.type;
    }

    public double getColor() {
        if (this.type == Type.Alarm) {
            switch (OnmsSeverity.get(this.getMaximumSeverity())) {
                case WARNING: {
                    return 0.1;
                }
                case MINOR: {
                    return 0.2;
                }
                case MAJOR: {
                    return 0.4;
                }
                case CRITICAL: {
                    return 1.0;
                }
            }
            return 0.0;
        }
        if (this.getServicesTotal() == 0) {
            return 0.0;
        }
        return (double)this.getServicesDown() / (double)this.getServicesTotal();
    }

    public static enum Type {
        Outage,
        Alarm;

    }
}

