/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="requisitioned_categories")
public class RequisitionedCategoryAssociation
implements Serializable,
Comparable<RequisitionedCategoryAssociation> {
    private static final long serialVersionUID = 1L;
    private Integer m_id;
    private OnmsNode m_node;
    private OnmsCategory m_category;

    public RequisitionedCategoryAssociation() {
    }

    public RequisitionedCategoryAssociation(OnmsNode node, OnmsCategory category) {
        this.m_node = node;
        this.m_category = category;
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @Column(name="id")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne
    @JoinColumn(name="nodeId", nullable=false)
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @ManyToOne
    @JoinColumn(name="categoryId", nullable=false)
    public OnmsCategory getCategory() {
        return this.m_category;
    }

    public void setCategory(OnmsCategory category) {
        this.m_category = category;
    }

    public String toString() {
        return "RequisitionedCategoryAssociation [id=" + this.m_id + ", node=" + this.m_node.getId() + ", category=" + this.m_category.getName() + "]";
    }

    @Override
    public int compareTo(RequisitionedCategoryAssociation o) {
        int ret = this.m_node.compareTo(o.m_node);
        if (ret == 0) {
            ret = this.m_category.compareTo(o.m_category);
        }
        return ret;
    }
}

