/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.icmp.proxy.PingRequest;
import org.opennms.netmgt.icmp.proxy.PingResponse;
import org.opennms.netmgt.icmp.proxy.PingSequence;

public class PingSummary {
    private final List<PingSequence> sequences = Lists.newArrayList();
    private final int numberRequests;
    private final PingRequest request;

    public PingSummary(PingRequest request, int numberOfRequests) {
        this.numberRequests = numberOfRequests;
        this.request = Objects.requireNonNull(request);
    }

    public void addSequence(int sequenceId, PingResponse pingResponse) {
        Objects.requireNonNull(pingResponse);
        this.sequences.add(new PingSequence(sequenceId, pingResponse));
    }

    public void addSequence(int sequenceId, Throwable exception) {
        Objects.requireNonNull(exception);
        this.sequences.add(new PingSequence(sequenceId, exception));
    }

    public boolean isComplete() {
        return this.numberRequests == this.sequences.size();
    }

    public boolean isSuccess() {
        return this.isComplete() && this.sequences.stream().filter(eachSequence -> eachSequence.isError() || eachSequence.isTimeout()).count() == 0L;
    }

    public PingSequence getSequence(int sequenceIndex) {
        return this.getSequences().get(sequenceIndex);
    }

    public List<PingSequence> getSequences() {
        return this.sequences.stream().sorted((s1, s2) -> Integer.compare(s1.getSequenceNumber(), s2.getSequenceNumber())).collect(Collectors.toList());
    }

    public PingRequest getRequest() {
        return this.request;
    }

    public void addSequence(PingSequence sequence) {
        this.sequences.add(sequence);
    }

    public int getNumberRequests() {
        return this.numberRequests;
    }
}

