/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.search;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Term {
    private final String m_field;
    private final String m_value;

    public Term(String field, String value) {
        this.m_field = field;
        this.m_value = (String)Preconditions.checkNotNull((Object)value, (Object)"value argument");
    }

    public Term(String value) {
        this(null, value);
    }

    public String getField(String defaultField) {
        return this.m_field == null ? defaultField : this.m_field;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        return Objects.equal((Object)this.m_field, (Object)other.m_field) && Objects.equal((Object)this.m_value, (Object)other.m_value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_field, this.m_value});
    }

    public String toString() {
        return this.m_field == null ? Term.escapeChars(this.m_value) : String.format("%s:%s", Term.escapeChars(this.m_field), Term.escapeChars(this.m_value));
    }

    private static String escapeChars(String token) {
        token = token.replace("\\", "\\\\");
        token = token.replace(":", "\\:");
        return token;
    }
}

