/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.topology.UserDefinedLink;
import org.opennms.integration.api.v1.topology.UserDefinedLinkDao;
import org.opennms.integration.api.v1.topology.immutables.ImmutableUserDefinedLink;

public class UserDefinedLinkHealthCheck
implements HealthCheck {
    private final UserDefinedLinkDao userDefinedLinkDao;
    private final NodeDao nodeDao;
    private final Random random = new Random();

    public UserDefinedLinkHealthCheck(UserDefinedLinkDao userDefinedLinkDao, NodeDao nodeDao) {
        this.userDefinedLinkDao = Objects.requireNonNull(userDefinedLinkDao);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: User Defined Link";
    }

    public Response perform(Context context) {
        List nodes = this.nodeDao.getNodes();
        if (nodes.size() < 2) {
            return ImmutableResponse.newInstance((Status)Status.Success);
        }
        String uniqueLabel = String.format("%d-%d", System.currentTimeMillis(), this.random.nextLong());
        Node nodeA = (Node)nodes.get(0);
        Node nodeZ = (Node)nodes.get(1);
        ImmutableUserDefinedLink link = ImmutableUserDefinedLink.newBuilder().setNodeIdA(nodeA.getId()).setNodeIdZ(nodeZ.getId()).setLinkLabel(uniqueLabel).setLinkId(uniqueLabel).setOwner("test").build();
        List links = this.userDefinedLinkDao.getLinksWithLabel(uniqueLabel);
        if (!links.isEmpty()) {
            return ImmutableResponse.newInstance((Status)Status.Failure, (String)String.format("A link with label %s already exists!", uniqueLabel));
        }
        link = this.userDefinedLinkDao.saveOrUpdate((UserDefinedLink)link);
        links = this.userDefinedLinkDao.getLinksWithLabel(uniqueLabel);
        if (links.size() != 1) {
            return ImmutableResponse.newInstance((Status)Status.Failure, (String)String.format("Expected 1 link, but found: %d", links.size()));
        }
        this.userDefinedLinkDao.delete((UserDefinedLink)link);
        return ImmutableResponse.newInstance((Status)Status.Success);
    }
}

