/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.TopologyEdge;
import org.opennms.integration.api.v1.model.TopologyPort;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.integration.api.v1.model.TopologySegment;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode;
import org.opennms.integration.api.v1.model.immutables.ImmutableTopologyPort;
import org.opennms.integration.api.v1.model.immutables.ImmutableTopologySegment;

public final class ImmutableTopologyEdge
implements TopologyEdge {
    private final TopologyProtocol protocol;
    private final String id;
    private final String tooltipText;
    private final Object source;
    private final Object target;
    private final TopologyEdge.EndpointType sourceType;
    private final TopologyEdge.EndpointType targetType;

    private ImmutableTopologyEdge(Builder builder) {
        this.protocol = builder.protocol;
        this.id = builder.id;
        this.tooltipText = builder.tooltipText;
        this.sourceType = builder.sourceType;
        this.targetType = builder.targetType;
        switch (this.sourceType) {
            case NODE: {
                this.source = ImmutableNode.immutableCopy((Node)builder.source);
                break;
            }
            case PORT: {
                this.source = ImmutableTopologyPort.immutableCopy((TopologyPort)builder.source);
                break;
            }
            case SEGMENT: {
                this.source = ImmutableTopologySegment.immutableCopy((TopologySegment)builder.source);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported source type " + this.sourceType);
            }
        }
        switch (this.targetType) {
            case NODE: {
                this.target = ImmutableNode.immutableCopy((Node)builder.target);
                break;
            }
            case PORT: {
                this.target = ImmutableTopologyPort.immutableCopy((TopologyPort)builder.target);
                break;
            }
            case SEGMENT: {
                this.target = ImmutableTopologySegment.immutableCopy((TopologySegment)builder.target);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported target type " + this.targetType);
            }
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(TopologyEdge topologyEdge) {
        return new Builder(topologyEdge);
    }

    public static TopologyEdge immutableCopy(TopologyEdge topologyEdge) {
        if (topologyEdge == null || topologyEdge instanceof ImmutableTopologyEdge) {
            return topologyEdge;
        }
        return ImmutableTopologyEdge.newBuilderFrom(topologyEdge).build();
    }

    public TopologyProtocol getProtocol() {
        return this.protocol;
    }

    public String getId() {
        return this.id;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void visitEndpoints(TopologyEdge.EndpointVisitor v) {
        switch (this.sourceType) {
            case NODE: {
                v.visitSource((Node)this.source);
                break;
            }
            case PORT: {
                v.visitSource((TopologyPort)this.source);
                break;
            }
            case SEGMENT: {
                v.visitSource((TopologySegment)this.source);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Source type '%s' is unsupported", this.sourceType));
            }
        }
        switch (this.targetType) {
            case NODE: {
                v.visitTarget((Node)this.target);
                break;
            }
            case PORT: {
                v.visitTarget((TopologyPort)this.target);
                break;
            }
            case SEGMENT: {
                v.visitTarget((TopologySegment)this.target);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Target type '%s' is unsupported", this.sourceType));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTopologyEdge that = (ImmutableTopologyEdge)o;
        return this.protocol == that.protocol && Objects.equals(this.id, that.id) && Objects.equals(this.tooltipText, that.tooltipText) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && this.sourceType == that.sourceType && this.targetType == that.targetType;
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.id, this.tooltipText, this.source, this.target, this.sourceType, this.targetType);
    }

    public String toString() {
        return "ImmutableTopologyEdge{protocol=" + this.protocol + ", id='" + this.id + '\'' + ", tooltipText='" + this.tooltipText + '\'' + ", source=" + this.source + ", target=" + this.target + ", sourceType=" + this.sourceType + ", targetType=" + this.targetType + '}';
    }

    public static final class Builder {
        private TopologyProtocol protocol;
        private String id;
        private String tooltipText;
        private Object source;
        private Object target;
        private TopologyEdge.EndpointType sourceType;
        private TopologyEdge.EndpointType targetType;

        private Builder() {
        }

        private Builder(TopologyEdge topologyEdge) {
            this.protocol = topologyEdge.getProtocol();
            this.id = topologyEdge.getId();
            this.tooltipText = topologyEdge.getTooltipText();
            topologyEdge.visitEndpoints(new TopologyEdge.EndpointVisitor(){

                public void visitSource(Node node) {
                    source = node;
                    sourceType = TopologyEdge.EndpointType.NODE;
                }

                public void visitSource(TopologyPort port) {
                    source = port;
                    sourceType = TopologyEdge.EndpointType.PORT;
                }

                public void visitSource(TopologySegment segment) {
                    source = segment;
                    sourceType = TopologyEdge.EndpointType.SEGMENT;
                }

                public void visitTarget(Node node) {
                    target = node;
                    targetType = TopologyEdge.EndpointType.NODE;
                }

                public void visitTarget(TopologyPort port) {
                    target = port;
                    targetType = TopologyEdge.EndpointType.PORT;
                }

                public void visitTarget(TopologySegment segment) {
                    target = segment;
                    targetType = TopologyEdge.EndpointType.SEGMENT;
                }
            });
        }

        public Builder setProtocol(TopologyProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol);
            return this;
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setTooltipText(String tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public Builder setSource(Node source) {
            this.source = source;
            this.sourceType = TopologyEdge.EndpointType.NODE;
            return this;
        }

        public Builder setSource(TopologyPort source) {
            this.source = source;
            this.sourceType = TopologyEdge.EndpointType.PORT;
            return this;
        }

        public Builder setSource(TopologySegment source) {
            this.source = source;
            this.sourceType = TopologyEdge.EndpointType.SEGMENT;
            return this;
        }

        public Builder setTarget(Node target) {
            this.target = target;
            this.targetType = TopologyEdge.EndpointType.NODE;
            return this;
        }

        public Builder setTarget(TopologyPort target) {
            this.target = target;
            this.targetType = TopologyEdge.EndpointType.PORT;
            return this;
        }

        public Builder setTarget(TopologySegment target) {
            this.target = target;
            this.targetType = TopologyEdge.EndpointType.SEGMENT;
            return this;
        }

        public ImmutableTopologyEdge build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.protocol);
            Objects.requireNonNull(this.source);
            Objects.requireNonNull(this.target);
            Objects.requireNonNull(this.sourceType);
            Objects.requireNonNull(this.targetType);
            return new ImmutableTopologyEdge(this);
        }
    }
}

