/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.SnmpInterface;

public final class ImmutableSnmpInterface
implements SnmpInterface {
    private final String ifDescr;
    private final String ifName;
    private final Integer ifIndex;

    private ImmutableSnmpInterface(Builder builder) {
        this.ifDescr = builder.ifDescr;
        this.ifName = builder.ifName;
        this.ifIndex = builder.ifIndex;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(SnmpInterface snmpInterface) {
        return new Builder(snmpInterface);
    }

    public static SnmpInterface immutableCopy(SnmpInterface snmpInterface) {
        if (snmpInterface == null || snmpInterface instanceof ImmutableSnmpInterface) {
            return snmpInterface;
        }
        return ImmutableSnmpInterface.newBuilderFrom(snmpInterface).build();
    }

    public String getIfDescr() {
        return this.ifDescr;
    }

    public String getIfName() {
        return this.ifName;
    }

    public Integer getIfIndex() {
        return this.ifIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSnmpInterface that = (ImmutableSnmpInterface)o;
        return Objects.equals(this.ifDescr, that.ifDescr) && Objects.equals(this.ifName, that.ifName) && Objects.equals(this.ifIndex, that.ifIndex);
    }

    public int hashCode() {
        return Objects.hash(this.ifDescr, this.ifName, this.ifIndex);
    }

    public String toString() {
        return "ImmutableSnmpInterface{ifDescr='" + this.ifDescr + '\'' + ", ifName='" + this.ifName + '\'' + ", ifIndex=" + this.ifIndex + '}';
    }

    public static final class Builder {
        private String ifDescr;
        private String ifName;
        private Integer ifIndex;

        private Builder() {
        }

        private Builder(SnmpInterface snmpInterface) {
            this.ifDescr = snmpInterface.getIfDescr();
            this.ifName = snmpInterface.getIfName();
            this.ifIndex = snmpInterface.getIfIndex();
        }

        public Builder setIfDescr(String ifDescr) {
            this.ifDescr = ifDescr;
            return this;
        }

        public Builder setIfName(String ifName) {
            this.ifName = ifName;
            return this;
        }

        public Builder setIfIndex(Integer ifIndex) {
            this.ifIndex = ifIndex;
            return this;
        }

        public ImmutableSnmpInterface build() {
            return new ImmutableSnmpInterface(this);
        }
    }
}

