/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.immutables.ImmutableEventParameter;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableDatabaseEvent
implements DatabaseEvent {
    private final String uei;
    private final Integer id;
    private final List<EventParameter> parameters;

    private ImmutableDatabaseEvent(Builder builder) {
        this.uei = builder.uei;
        this.id = builder.id;
        this.parameters = ImmutableCollections.with(ImmutableEventParameter::immutableCopy).newList(builder.parameters);
    }

    public DatabaseEvent ImmutableCopy(DatabaseEvent databaseEvent) {
        if (databaseEvent == null || databaseEvent instanceof ImmutableDatabaseEvent) {
            return databaseEvent;
        }
        return ImmutableDatabaseEvent.newBuilderFrom(databaseEvent).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(DatabaseEvent databaseEvent) {
        return new Builder(databaseEvent);
    }

    public String getUei() {
        return this.uei;
    }

    public Integer getId() {
        return this.id;
    }

    public List<EventParameter> getParameters() {
        return this.parameters;
    }

    public List<EventParameter> getParametersByName(String name) {
        return this.parameters.stream().filter(param -> param.getName().equals(name)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDatabaseEvent that = (ImmutableDatabaseEvent)o;
        return Objects.equals(this.uei, that.uei) && Objects.equals(this.id, that.id) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.uei, this.id, this.parameters);
    }

    public String toString() {
        return "ImmutableDatabaseEvent{uei='" + this.uei + '\'' + ", id=" + this.id + ", parameters=" + this.parameters + '}';
    }

    public static final class Builder {
        private String uei;
        private Integer id;
        private List<EventParameter> parameters;

        private Builder() {
        }

        private Builder(DatabaseEvent databaseEvent) {
            this.uei = databaseEvent.getUei();
            this.id = databaseEvent.getId();
            this.parameters = MutableCollections.copyListFromNullable(databaseEvent.getParameters());
        }

        public Builder setUei(String uei) {
            this.uei = uei;
            return this;
        }

        public Builder setId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder setParameters(List<EventParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addParameter(EventParameter parameter) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<EventParameter>();
            }
            this.parameters.add(parameter);
            return this;
        }

        public ImmutableDatabaseEvent build() {
            return new ImmutableDatabaseEvent(this);
        }
    }
}

