/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.event;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.netmgt.events.api.model.ILogMsg;
import org.opennms.netmgt.xml.event.OnmsStringBuilder;

@XmlRootElement(name="logmsg")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Logmsg
implements Serializable {
    private static final long serialVersionUID = -7173862847984790914L;
    @XmlValue
    @NotNull
    private String _content = "";
    @XmlAttribute(name="notify")
    private Boolean _notify = true;
    @XmlAttribute(name="dest")
    @Pattern(regexp="(logndisplay|displayonly|logonly|suppress|donotpersist)")
    private String _dest = "logndisplay";

    public Logmsg() {
        this.setContent("");
        this.setDest("logndisplay");
    }

    public static Logmsg copyFrom(ILogMsg source) {
        if (source == null) {
            return null;
        }
        Logmsg logmsg = new Logmsg();
        logmsg.setContent(source.getContent());
        logmsg.setDest(source.getDest());
        logmsg.setNotify(source.hasNotify() ? source.getNotify() : null);
        return logmsg;
    }

    public void deleteNotify() {
        this._notify = null;
    }

    public String getContent() {
        return this._content;
    }

    public String getDest() {
        return this._dest;
    }

    public Boolean getNotify() {
        return this._notify == null ? false : this._notify;
    }

    public boolean hasNotify() {
        return this._notify != null;
    }

    public Boolean isNotify() {
        return this.getNotify();
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setDest(String dest) {
        this._dest = dest;
    }

    public void setNotify(Boolean notify) {
        this._notify = notify;
    }

    public String toString() {
        return new OnmsStringBuilder(this).toString();
    }
}

