/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.opennms.netmgt.events.api.EventDatetimeFormatter;

public class LegacyDatetimeFormatter
implements EventDatetimeFormatter {
    public static final ThreadLocal<DateFormat> FORMATTER_FULL = ThreadLocal.withInitial(() -> {
        int timeFormat = 0;
        String language = Locale.getDefault().getLanguage();
        if (language.equals(Locale.FRANCE.getLanguage()) || language.equals(Locale.GERMANY.getLanguage())) {
            timeFormat = 1;
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(0, timeFormat);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_LONG = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_FULL_GMT = ThreadLocal.withInitial(() -> {
        int timeFormat = 0;
        String language = Locale.getDefault().getLanguage();
        if (language.equals(Locale.FRANCE.getLanguage()) || language.equals(Locale.GERMANY.getLanguage())) {
            timeFormat = 1;
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(0, timeFormat);
        formatter.setLenient(true);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_LONG_GMT = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
        formatter.setLenient(true);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_CUSTOM = ThreadLocal.withInitial(() -> {
        SimpleDateFormat formatter = new SimpleDateFormat("EEEEE, d MMMMM yyyy k:mm:ss 'o''clock' z", Locale.ENGLISH);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_DEFAULT = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        formatter.setLenient(true);
        return formatter;
    });

    @Override
    public Date parse(String dateString) throws ParseException {
        if (dateString == null) {
            throw new ParseException("time was null!", -1);
        }
        try {
            return FORMATTER_LONG.get().parse(dateString);
        }
        catch (ParseException parseException) {
            try {
                return FORMATTER_CUSTOM.get().parse(dateString);
            }
            catch (ParseException pe) {
                try {
                    return FORMATTER_FULL.get().parse(dateString);
                }
                catch (Exception fpe) {
                    try {
                        return Date.from(ZonedDateTime.parse(dateString).toInstant());
                    }
                    catch (DateTimeParseException dtpe) {
                        throw new ParseException("failed to parse " + dateString + " as an ISO date; giving up", dtpe.getErrorIndex());
                    }
                    catch (Exception isoe) {
                        throw new ParseException("failed to parse " + dateString + " as an ISO date; giving up", 0);
                    }
                }
            }
        }
    }

    @Override
    public String format(Date date) {
        return FORMATTER_LONG_GMT.get().format(date);
    }
}

