/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.MacCloud;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;

public interface TopologyService {
    public static <L, R> TopologyConnection<L, R> of(L left, R right) {
        return new TopologyConnection<L, R>(left, right);
    }

    public static TopologyShared of(SharedSegment shs, List<MacPort> macPortsOnSegment) {
        TopologyShared tps = new TopologyShared(new ArrayList<BridgePort>(shs.getBridgePortsOnSegment()), macPortsOnSegment, shs.getDesignatedPort());
        HashSet<String> noPortMacs = new HashSet<String>(shs.getMacsOnSegment());
        macPortsOnSegment.forEach(mp -> noPortMacs.removeAll(mp.getMacPortMap().keySet()));
        if (noPortMacs.size() > 0) {
            tps.setCloud(new MacCloud(noPortMacs));
        }
        return tps;
    }

    public boolean parseUpdates();

    public void updatesAvailable();

    public boolean hasUpdates();

    public void refresh();
}

