/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class MacPort
implements Topology {
    private Integer m_nodeId;
    private Integer m_macPortIfIndex;
    private String m_macPortName;
    private final Map<String, Set<InetAddress>> m_macPortMap = new HashMap<String, Set<InetAddress>>();

    public String getPortMacInfo() {
        StringBuffer strbfr = new StringBuffer();
        this.m_macPortMap.keySet().forEach(mac -> {
            strbfr.append("ip:[");
            this.m_macPortMap.get(mac).forEach(ip -> {
                strbfr.append(InetAddressUtils.str((InetAddress)ip));
                strbfr.append(" ");
            });
            strbfr.append("], mac:[");
            strbfr.append((String)mac);
            strbfr.append("]");
        });
        return strbfr.toString();
    }

    @Override
    public String printTopology() {
        return "nodeid:[" + this.m_nodeId + "], port name:[" + this.m_macPortName + "], ifindex:[" + this.m_macPortIfIndex + "], macPortMap:[" + this.m_macPortMap + "]";
    }

    public Integer getIfIndex() {
        return this.m_macPortIfIndex;
    }

    public void setIfIndex(Integer macPortIfIndex) {
        this.m_macPortIfIndex = macPortIfIndex;
    }

    public String getMacPortName() {
        return this.m_macPortName;
    }

    public void setMacPortName(String macPortName) {
        this.m_macPortName = macPortName;
    }

    public Map<String, Set<InetAddress>> getMacPortMap() {
        return this.m_macPortMap;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_macPortIfIndex == null ? 0 : this.m_macPortIfIndex.hashCode());
        result = 31 * result + this.m_macPortMap.hashCode();
        result = 31 * result + (this.m_macPortName == null ? 0 : this.m_macPortName.hashCode());
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacPort other = (MacPort)obj;
        if (this.m_macPortIfIndex == null ? other.m_macPortIfIndex != null : !this.m_macPortIfIndex.equals(other.m_macPortIfIndex)) {
            return false;
        }
        if (!this.m_macPortMap.equals(other.m_macPortMap)) {
            return false;
        }
        if (this.m_macPortName == null ? other.m_macPortName != null : !this.m_macPortName.equals(other.m_macPortName)) {
            return false;
        }
        if (this.m_nodeId == null) {
            return other.m_nodeId == null;
        }
        return this.m_nodeId.equals(other.m_nodeId);
    }
}

