/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.net.InetAddress;
import java.util.Optional;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class IpInterfaceTopologyEntity {
    private final Integer id;
    private final InetAddress ipAddress;
    private final InetAddress netMask;
    private final String isManaged;
    private final PrimaryType isSnmpPrimary;
    private final Integer nodeId;
    private final Integer snmpInterfaceId;

    public IpInterfaceTopologyEntity(Integer id, InetAddress ipAddress, InetAddress netMask, String isManaged, PrimaryType isSnmpPrimary, Integer nodeId, Integer snmpInterfaceId) {
        this.id = id;
        this.ipAddress = ipAddress;
        this.netMask = netMask;
        this.isManaged = isManaged;
        this.isSnmpPrimary = isSnmpPrimary;
        this.nodeId = nodeId;
        this.snmpInterfaceId = snmpInterfaceId;
    }

    public IpInterfaceTopologyEntity(Integer id, InetAddress ipAddress, InetAddress netMask, String isManaged, String snmpPrimary, Integer nodeId, Integer snmpInterfaceId) {
        this(id, ipAddress, netMask, isManaged, PrimaryType.get((Object)snmpPrimary), nodeId, snmpInterfaceId);
    }

    public static IpInterfaceTopologyEntity create(OnmsIpInterface ipInterface) {
        return new IpInterfaceTopologyEntity(ipInterface.getId(), ipInterface.getIpAddress(), ipInterface.getNetMask(), ipInterface.getIsManaged(), ipInterface.getIsSnmpPrimary(), (Integer)Optional.ofNullable(ipInterface.getNode()).map(OnmsNode::getId).orElse(null), (Integer)Optional.ofNullable(ipInterface.getSnmpInterface()).map(OnmsSnmpInterface::getId).orElse(null));
    }

    public Integer getId() {
        return this.id;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public InetAddress getNetMask() {
        return this.netMask;
    }

    public String getIsManaged() {
        return this.isManaged;
    }

    public boolean isManaged() {
        return "M".equals(this.getIsManaged());
    }

    public char snmpPrimary() {
        return this.isSnmpPrimary.getCharCode();
    }

    public PrimaryType getIsSnmpPrimary() {
        return this.isSnmpPrimary;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public Integer getSnmpInterfaceId() {
        return this.snmpInterfaceId;
    }

    public String toString() {
        return "IpInterfaceTopologyEntity{id=" + this.id + ", ipAddress=" + this.ipAddress + ", netMask=" + this.netMask + ", isManaged='" + this.isManaged + "', isSnmpPrimary=" + this.isSnmpPrimary + ", nodeId=" + this.nodeId + ", snmpInterfaceId=" + this.snmpInterfaceId + "}";
    }
}

