/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.broker.impl;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.opennms.features.activemq.broker.api.ManagedBroker;
import org.opennms.features.activemq.broker.api.ManagedDestination;
import org.opennms.features.activemq.broker.impl.ManagedDestinationImpl;

public class ManagedBrokerImpl
implements ManagedBroker {
    private final BrokerService brokerService;

    public ManagedBrokerImpl(BrokerService brokerService) {
        this.brokerService = Objects.requireNonNull(brokerService);
    }

    @Override
    public int getCurrentConnections() {
        try {
            return this.brokerService.getCurrentConnections();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMemoryPercentUsage() {
        try {
            return this.brokerService.getProducerSystemUsage().getMemoryUsage().getPercentUsage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMemoryUsage() {
        try {
            return this.brokerService.getProducerSystemUsage().getMemoryUsage().getUsage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMemoryLimit() {
        try {
            return this.brokerService.getProducerSystemUsage().getMemoryUsage().getLimit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ManagedDestination> getDestinations() {
        try {
            return this.brokerService.getBroker().getDestinationMap().entrySet().stream().map(e -> new ManagedDestinationImpl((ActiveMQDestination)e.getKey(), (Destination)e.getValue())).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

