/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.openl.rules.ruleservice.management.ServiceManagerImpl;
import org.openl.rules.ruleservice.servlet.DestinationRegistryInvocationHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WSServlet
extends CXFServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        super.init();
        ServletConfig servletConfig = this.getServletConfig();
        this.loadBus(servletConfig);
        this.configureDestinationRegistry(servletConfig.getInitParameter("uriEncoding"));
        ServletContext context = this.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        if (!applicationContext.containsBean("serviceManager")) {
            throw new ServletException("Could not instantiate service manager. Make sure that you have configured bean \"ruleService\"");
        }
        ServiceManagerImpl serviceManager = (ServiceManagerImpl)applicationContext.getBean("serviceManager");
        serviceManager.start();
    }

    private void configureDestinationRegistry(final String uriEncoding) {
        if (uriEncoding == null) {
            return;
        }
        final Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        this.getBus().setExtension((Object)new Configurer(){

            public void configureBean(Object beanInstance) {
                configurer.configureBean(beanInstance);
                this.configureHttpTransportFactory(beanInstance);
            }

            public void configureBean(String name, Object beanInstance) {
                configurer.configureBean(name, beanInstance);
                this.configureHttpTransportFactory(beanInstance);
            }

            private void configureHttpTransportFactory(Object beanInstance) {
                if (beanInstance instanceof HTTPTransportFactory) {
                    HTTPTransportFactory factory = (HTTPTransportFactory)beanInstance;
                    factory.setRegistry(this.createDestinationRegistry(factory.getRegistry()));
                }
            }

            private DestinationRegistry createDestinationRegistry(DestinationRegistry oldRegistry) {
                if (Proxy.isProxyClass(oldRegistry.getClass()) && Proxy.getInvocationHandler(oldRegistry) instanceof DestinationRegistryInvocationHandler) {
                    return oldRegistry;
                }
                Class<?> type = oldRegistry.getClass();
                return (DestinationRegistry)Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)new DestinationRegistryInvocationHandler(oldRegistry, uriEncoding));
            }
        }, Configurer.class);
    }
}

