/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openl.rules.ruleservice.publish.MultipleRuleServicePublisher;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.servlet.AvailableServicesGroup;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServicesListServlet
extends HttpServlet {
    private static final long serialVersionUID = 714926204750487226L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RuleServicePublisher ruleServicePublisher = (RuleServicePublisher)WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext()).getBean("ruleServicePublisher");
        request.setAttribute("servicesGroup", this.getServicesGroup(ruleServicePublisher));
        RequestDispatcher rd = request.getRequestDispatcher("/services/index.jsp");
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    public List<AvailableServicesGroup> getServicesGroup(RuleServicePublisher ruleServicePublisher) {
        ArrayList<AvailableServicesGroup> services = new ArrayList<AvailableServicesGroup>();
        this.addServicesGroup(services, ruleServicePublisher);
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            AvailableServicesGroup servicesGroup = (AvailableServicesGroup)iterator.next();
            if (!servicesGroup.getAvailableServices().isEmpty()) continue;
            iterator.remove();
        }
        return services;
    }

    private void addServicesGroup(List<AvailableServicesGroup> services, RuleServicePublisher publisher) {
        if (publisher instanceof AvailableServicesGroup) {
            if (services.contains(publisher)) {
                return;
            }
            services.add((AvailableServicesGroup)publisher);
        }
        if (publisher instanceof MultipleRuleServicePublisher) {
            MultipleRuleServicePublisher multiplePublisher = (MultipleRuleServicePublisher)publisher;
            this.addServicesGroup(services, multiplePublisher.getDefaultRuleServicePublisher());
            for (RuleServicePublisher p : multiplePublisher.getSupportedPublishers()) {
                this.addServicesGroup(services, p);
            }
        }
    }
}

