/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;

public class DestinationRegistryInvocationHandler
implements InvocationHandler {
    private final DestinationRegistry destinationRegistry;
    private final String encoding;
    private final Map<String, AbstractHTTPDestination> decodedDestinations = new ConcurrentHashMap<String, AbstractHTTPDestination>();

    public DestinationRegistryInvocationHandler(DestinationRegistry destinationRegistry, String encoding) {
        this.destinationRegistry = destinationRegistry;
        this.encoding = encoding;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.destinationRegistry, args);
        String methodName = method.getName();
        if (methodName.equals("addDestination") && args.length == 1 && args[0] instanceof AbstractHTTPDestination) {
            this.addDestination((AbstractHTTPDestination)args[0]);
        } else if (methodName.equals("removeDestination") && args.length == 1 && args[0] instanceof String) {
            this.removeDestination((String)args[0]);
        } else if (methodName.equals("getDestinationForPath") && args.length == 2 && args[0] instanceof String && args[1] instanceof Boolean) {
            result = this.getDestinationForPath((AbstractHTTPDestination)result, (String)args[0], (Boolean)args[1]);
        }
        return result;
    }

    private void addDestination(AbstractHTTPDestination destination) {
        String path = this.getTrimmedPath(destination.getEndpointInfo().getAddress());
        try {
            String decodedPath = URLDecoder.decode(path, this.encoding);
            if (!path.equals(decodedPath)) {
                this.decodedDestinations.put(decodedPath, destination);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding", e);
        }
    }

    private void removeDestination(String path) {
        try {
            String decodedPath = URLDecoder.decode(path, this.encoding);
            if (!path.equals(decodedPath)) {
                this.decodedDestinations.remove(decodedPath);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding", e);
        }
    }

    private AbstractHTTPDestination getDestinationForPath(AbstractHTTPDestination withoutDecoding, String path, boolean tryDecoding) {
        if (withoutDecoding != null) {
            return withoutDecoding;
        }
        if (tryDecoding) {
            String trimmedPath = this.getTrimmedPath(path);
            return this.decodedDestinations.get(trimmedPath);
        }
        return null;
    }

    public String getTrimmedPath(String path) {
        if (path == null) {
            return "/";
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path.startsWith("http://localhost/")) {
            path = path.substring("http://localhost/".length());
        } else if (path.startsWith("https://localhost/")) {
            path = path.substring("https://localhost/".length());
        }
        if (!path.contains("://") && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

