/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceRedeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.servlet.AvailableServicesGroup;
import org.openl.rules.ruleservice.servlet.ServiceInfo;
import org.springframework.beans.factory.ObjectFactory;

public class WebServicesRuleServicePublisher
implements RuleServicePublisher,
AvailableServicesGroup {
    private ObjectFactory<?> serverFactory;
    private Map<OpenLService, ServiceServer> runningServices = new HashMap<OpenLService, ServiceServer>();
    private String baseAddress;
    private List<ServiceInfo> availableServices = new ArrayList<ServiceInfo>();

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String address) {
        this.baseAddress = address;
    }

    public ObjectFactory<?> getServerFactory() {
        return this.serverFactory;
    }

    public void setServerFactory(ObjectFactory<?> serverFactory) {
        this.serverFactory = serverFactory;
    }

    ServerFactoryBean getServerFactoryBean() {
        if (this.serverFactory != null) {
            return (ServerFactoryBean)this.serverFactory.getObject();
        }
        return new ServerFactoryBean();
    }

    protected String processURL(String url) {
        String[] parts = url.split("/");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : parts) {
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            try {
                sb.append(URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(s);
            }
        }
        String ret = sb.toString();
        while (ret.charAt(0) == '/') {
            ret = ret.substring(1);
        }
        return ret;
    }

    public void deploy(OpenLService service) throws RuleServiceDeployException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(service.getServiceClass().getClassLoader());
        ServerFactoryBean svrFactory = this.getServerFactoryBean();
        String url = this.processURL(service.getUrl());
        String serviceAddress = this.getBaseAddress() + url;
        svrFactory.setAddress(serviceAddress);
        svrFactory.setServiceClass(service.getServiceClass());
        svrFactory.setServiceBean(service.getServiceBean());
        try {
            Server wsServer = svrFactory.create();
            ServiceServer serviceServer = new ServiceServer(wsServer, svrFactory.getDataBinding());
            this.runningServices.put(service, serviceServer);
            this.availableServices.add(this.createServiceInfo(service));
        }
        catch (Exception t) {
            throw new RuleServiceDeployException(String.format("Failed to deploy service \"%s\"", service.getName()), (Throwable)t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public DataBinding getDataBinding(String serviceName) {
        OpenLService service = this.getServiceByName(serviceName);
        if (service == null) {
            return null;
        }
        return this.runningServices.get(service).getDatabinding();
    }

    public Collection<OpenLService> getServices() {
        return Collections.unmodifiableCollection(this.runningServices.keySet());
    }

    public OpenLService getServiceByName(String name) {
        for (OpenLService service : this.runningServices.keySet()) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public void undeploy(String serviceName) throws RuleServiceUndeployException {
        OpenLService service = this.getServiceByName(serviceName);
        if (service == null) {
            throw new RuleServiceUndeployException(String.format("There is no running service with name \"%s\"", serviceName));
        }
        try {
            this.runningServices.get(service).getServer().destroy();
            this.runningServices.remove(service);
            this.removeServiceInfo(serviceName);
            service.destroy();
        }
        catch (Exception t) {
            throw new RuleServiceUndeployException(String.format("Failed to undeploy service \"%s\"", serviceName), (Throwable)t);
        }
    }

    public void redeploy(OpenLService service) throws RuleServiceRedeployException {
        if (service == null) {
            throw new IllegalArgumentException("service argument can't be null");
        }
        try {
            this.undeploy(service.getName());
            this.deploy(service);
        }
        catch (RuleServiceDeployException e) {
            throw new RuleServiceRedeployException("Service redeploy was failed", (Throwable)e);
        }
        catch (RuleServiceUndeployException e) {
            throw new RuleServiceRedeployException("Service redeploy was failed", (Throwable)e);
        }
    }

    @Override
    public String getGroupName() {
        return "SOAP";
    }

    @Override
    public List<ServiceInfo> getAvailableServices() {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>(this.availableServices);
        Collections.sort(services, new Comparator<ServiceInfo>(){

            @Override
            public int compare(ServiceInfo o1, ServiceInfo o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return services;
    }

    private ServiceInfo createServiceInfo(OpenLService service) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (Method method : service.getServiceClass().getMethods()) {
            methodNames.add(method.getName());
        }
        Collections.sort(methodNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        String url = service.getUrl() + "?wsdl";
        return new ServiceInfo(new Date(), service.getName(), methodNames, url, "WSDL");
    }

    private void removeServiceInfo(String serviceName) {
        Iterator<ServiceInfo> iterator = this.availableServices.iterator();
        while (iterator.hasNext()) {
            ServiceInfo serviceInfo = iterator.next();
            if (!serviceInfo.getName().equals(serviceName)) continue;
            iterator.remove();
            break;
        }
    }

    private static class ServiceServer {
        private Server server;
        private DataBinding databinding;

        public ServiceServer(Server server, DataBinding dataBinding) {
            if (server == null) {
                throw new IllegalArgumentException("server arg can't be null!");
            }
            this.server = server;
            this.databinding = dataBinding;
        }

        public DataBinding getDatabinding() {
            return this.databinding;
        }

        public Server getServer() {
            return this.server;
        }
    }
}

