/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.databinding;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.management.ServiceDescriptionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class ServiceDescriptionConfigurationRootClassNamesBindingFactoryBean
extends AbstractFactoryBean<Set<String>> {
    private final Logger log = LoggerFactory.getLogger(ServiceDescriptionConfigurationRootClassNamesBindingFactoryBean.class);
    private static final String ROOT_CLASS_NAMES_BINDING = "rootClassNamesBinding";
    private Set<String> additionalRootClassNames;

    public void setAdditionalRootClassNames(Set<String> additionalRootClassNames) {
        if (additionalRootClassNames == null) {
            throw new IllegalArgumentException("addtionalRootClassNames arg can't be null");
        }
        this.additionalRootClassNames = additionalRootClassNames;
    }

    public Set<String> getAdditionalRootClassNames() {
        return this.additionalRootClassNames;
    }

    public boolean isSingleton() {
        return false;
    }

    protected Set<String> createInstance() throws Exception {
        ServiceDescription serviceDescription = ServiceDescriptionHolder.getInstance().getServiceDescription();
        if (serviceDescription != null && serviceDescription.getConfiguration() != null) {
            Object value;
            HashSet<String> ret = new HashSet<String>(this.getAdditionalRootClassNames());
            if (serviceDescription.getConfiguration() != null && (value = serviceDescription.getConfiguration().get(ROOT_CLASS_NAMES_BINDING)) instanceof String) {
                String[] rootClasses;
                StringBuilder classes = null;
                String v = (String)value;
                for (String className : rootClasses = v.split(",")) {
                    if (className == null || className.trim().length() <= 0) continue;
                    String trimmedClassName = className.trim();
                    ret.add(trimmedClassName);
                    if (classes == null) {
                        classes = new StringBuilder();
                    } else {
                        classes.append(", ");
                    }
                    classes.append(trimmedClassName);
                }
                this.log.info("Service \"{}\" uses root class names for binding. Classes: {}", (Object)serviceDescription.getName(), classes);
                return Collections.unmodifiableSet(ret);
            }
            return ret;
        }
        return Collections.unmodifiableSet(this.getAdditionalRootClassNames());
    }

    public Class<?> getObjectType() {
        return Set.class;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.additionalRootClassNames == null) {
            this.additionalRootClassNames = new HashSet<String>();
        }
    }
}

