/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.openjfx.gradle.JavaFXModule;
import org.openjfx.gradle.JavaFXPlatform;

public class JavaFXOptions {
    private static final String MAVEN_JAVAFX_ARTIFACT_GROUP_ID = "org.openjfx";
    private static final String JAVAFX_SDK_LIB_FOLDER = "lib";
    private final Project project;
    private final JavaFXPlatform platform;
    private String version = "13";
    private String sdk;
    private String configuration = "implementation";
    private String lastUpdatedConfiguration;
    private List<String> modules = new ArrayList<String>();
    private FlatDirectoryArtifactRepository customSDKArtifactRepository;

    public JavaFXOptions(Project project) {
        this.project = project;
        this.platform = JavaFXPlatform.detect(project);
    }

    public JavaFXPlatform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateJavaFXDependencies();
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
        this.updateJavaFXDependencies();
    }

    public String getSdk() {
        return this.sdk;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
        this.updateJavaFXDependencies();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
        this.updateJavaFXDependencies();
    }

    public void modules(String ... moduleNames) {
        this.setModules(List.of(moduleNames));
    }

    private void updateJavaFXDependencies() {
        this.clearJavaFXDependencies();
        String configuration = this.getConfiguration();
        JavaFXModule.getJavaFXModules(this.modules).forEach(javaFXModule -> {
            if (this.customSDKArtifactRepository != null) {
                this.project.getDependencies().add(configuration, Map.of("name", javaFXModule.getModuleName()));
            } else {
                this.project.getDependencies().add(configuration, (Object)String.format("%s:%s:%s:%s", MAVEN_JAVAFX_ARTIFACT_GROUP_ID, javaFXModule.getArtifactName(), this.getVersion(), this.getPlatform().getClassifier()));
            }
        });
        this.lastUpdatedConfiguration = configuration;
    }

    private void clearJavaFXDependencies() {
        if (this.customSDKArtifactRepository != null) {
            this.project.getRepositories().remove((Object)this.customSDKArtifactRepository);
            this.customSDKArtifactRepository = null;
        }
        if (this.sdk != null && !this.sdk.isEmpty()) {
            HashMap<String, Object> dirs = new HashMap<String, Object>();
            dirs.put("name", "customSDKArtifactRepository");
            if (this.sdk.endsWith(File.separator)) {
                dirs.put("dirs", this.sdk + JAVAFX_SDK_LIB_FOLDER);
            } else {
                dirs.put("dirs", this.sdk + File.separator + JAVAFX_SDK_LIB_FOLDER);
            }
            this.customSDKArtifactRepository = this.project.getRepositories().flatDir(dirs);
        }
        if (this.lastUpdatedConfiguration == null) {
            return;
        }
        Configuration configuration = (Configuration)this.project.getConfigurations().findByName(this.lastUpdatedConfiguration);
        if (configuration != null) {
            if (this.customSDKArtifactRepository != null) {
                configuration.getDependencies().removeIf(dependency -> dependency.getName().startsWith("javafx."));
            }
            configuration.getDependencies().removeIf(dependency -> MAVEN_JAVAFX_ARTIFACT_GROUP_ID.equals(dependency.getGroup()));
        }
    }
}

