/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.openjfx.gradle.JavaFXModule;
import org.openjfx.gradle.JavaFXPlatform;

public class JavaFXOptions {
    private static final String MAVEN_JAVAFX_ARTIFACT_GROUP_ID = "org.openjfx";
    private static final String JAVAFX_SDK_LIB_FOLDER = "lib";
    private final Project project;
    private JavaFXPlatform platform;
    private String version = "17";
    private String sdk;
    private String[] configurations = new String[]{"implementation"};
    private String[] lastUpdatedConfigurations;
    private List<String> modules = new ArrayList<String>();
    private FlatDirectoryArtifactRepository customSDKArtifactRepository;

    public JavaFXOptions(Project project) {
        this.project = project;
        this.platform = JavaFXPlatform.detect(project);
    }

    public JavaFXPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = JavaFXPlatform.fromString(platform);
        this.updateJavaFXDependencies();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateJavaFXDependencies();
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
        this.updateJavaFXDependencies();
    }

    public String getSdk() {
        return this.sdk;
    }

    public void setConfiguration(String configuration) {
        this.setConfigurations(new String[]{configuration});
    }

    public void setConfigurations(String[] configurations) {
        this.configurations = configurations;
        this.updateJavaFXDependencies();
    }

    public String getConfiguration() {
        return this.configurations[0];
    }

    public String[] getConfigurations() {
        return this.configurations;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
        this.updateJavaFXDependencies();
    }

    public void modules(String ... moduleNames) {
        this.setModules(List.of(moduleNames));
    }

    private void updateJavaFXDependencies() {
        String[] configurations;
        this.clearJavaFXDependencies();
        for (String conf : configurations = this.getConfigurations()) {
            JavaFXModule.getJavaFXModules(this.modules).stream().sorted().forEach(javaFXModule -> {
                if (this.customSDKArtifactRepository != null) {
                    this.project.getDependencies().add(conf, Map.of("name", javaFXModule.getModuleName()));
                } else {
                    this.project.getDependencies().add(conf, (Object)String.format("%s:%s:%s:%s", MAVEN_JAVAFX_ARTIFACT_GROUP_ID, javaFXModule.getArtifactName(), this.getVersion(), this.getPlatform().getClassifier()));
                }
            });
        }
        this.lastUpdatedConfigurations = configurations;
    }

    private void clearJavaFXDependencies() {
        if (this.customSDKArtifactRepository != null) {
            this.project.getRepositories().remove((Object)this.customSDKArtifactRepository);
            this.customSDKArtifactRepository = null;
        }
        if (this.sdk != null && !this.sdk.isEmpty()) {
            HashMap<String, Object> dirs = new HashMap<String, Object>();
            dirs.put("name", "customSDKArtifactRepository");
            if (this.sdk.endsWith(File.separator)) {
                dirs.put("dirs", this.sdk + JAVAFX_SDK_LIB_FOLDER);
            } else {
                dirs.put("dirs", this.sdk + File.separator + JAVAFX_SDK_LIB_FOLDER);
            }
            this.customSDKArtifactRepository = this.project.getRepositories().flatDir(dirs);
        }
        if (this.lastUpdatedConfigurations == null) {
            return;
        }
        for (String conf : this.lastUpdatedConfigurations) {
            Configuration configuration = (Configuration)this.project.getConfigurations().findByName(conf);
            if (configuration == null) continue;
            if (this.customSDKArtifactRepository != null) {
                configuration.getDependencies().removeIf(dependency -> dependency.getName().startsWith("javafx."));
            }
            configuration.getDependencies().removeIf(dependency -> MAVEN_JAVAFX_ARTIFACT_GROUP_ID.equals(dependency.getGroup()));
        }
    }
}

