/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import com.google.gradle.osdetector.OsDetector;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public enum JavaFXPlatform {
    LINUX("linux", "linux"),
    WINDOWS("win", "windows"),
    OSX("mac", "osx");

    private String classifier;
    private String osDetectorId;

    private JavaFXPlatform(String classifier, String osDetectorId) {
        this.classifier = classifier;
        this.osDetectorId = osDetectorId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public static JavaFXPlatform detect(Project project) {
        String os = ((OsDetector)project.getExtensions().getByType(OsDetector.class)).getOs();
        for (JavaFXPlatform platform : JavaFXPlatform.values()) {
            if (!platform.osDetectorId.equals(os)) continue;
            return platform;
        }
        String supportedPlatforms = Arrays.stream(JavaFXPlatform.values()).map(p -> p.osDetectorId).collect(Collectors.joining("', '", "'", "'"));
        throw new GradleException(String.format("Unsupported JavaFX platform found: '%s'! This plugin is designed to work on supported platforms only.Current supported platforms are %s.", os, supportedPlatforms));
    }
}

