/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jol.Operation;
import org.openjdk.jol.OptionFormatter;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.VM;

public abstract class ClasspathedOperation
implements Operation {
    @Override
    public void run(String[] args) throws Exception {
        List classes;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new OptionFormatter(this.label()));
        ArgumentAcceptingOptionSpec optClassPath = parser.accepts("cp", "Additional classpath entries, where to look for the referenced classes.").withRequiredArg().ofType(String.class).describedAs("classpath").withValuesSeparatedBy(System.getProperty("path.separator"));
        NonOptionArgumentSpec optClasses = parser.nonOptions("Class names to work on.");
        try {
            OptionSet set = parser.parse(args);
            classes = set.valuesOf((OptionSpec)optClasses);
            if (classes.isEmpty()) {
                System.err.println("Need class name(s) as the arguments.");
                System.err.println();
                parser.printHelpOn((OutputStream)System.err);
                return;
            }
            if (set.has((OptionSpec)optClassPath)) {
                ClassUtils.addClasspathEntries((Collection)optClassPath.values(set));
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.err);
            return;
        }
        System.out.println(VM.current().details());
        for (String klassName : classes) {
            try {
                this.runWith(ClassUtils.loadClass((String)klassName));
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    protected Object tryInstantiate(Class<?> klass) throws Exception {
        Constructor<?> ctor = klass.getDeclaredConstructor(new Class[0]);
        try {
            ctor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctor.newInstance(new Object[0]);
    }

    protected abstract void runWith(Class<?> var1) throws Exception;
}

