/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.lang.reflect.Constructor;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.operations.ClasspathedOPeration;

public class ObjectInternals
extends ClasspathedOPeration {
    @Override
    public String label() {
        return "internals";
    }

    @Override
    public String description() {
        return "Show the object internals: field layout and default contents, object header";
    }

    @Override
    public void runWith(Class<?> klass) throws Exception {
        try {
            Constructor<?> ctor = klass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            Object o = klass.newInstance();
            System.out.println(ClassLayout.parseInstance(o).toPrintable());
        }
        catch (NoSuchMethodException e) {
            System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
        catch (IllegalAccessException e) {
            System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
        catch (InstantiationException e) {
            System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
    }
}

