/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.lang.reflect.Constructor;
import org.openjdk.jol.Operation;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.util.VMSupport;

public class ObjectInternals
implements Operation {
    @Override
    public String label() {
        return "internals";
    }

    @Override
    public String description() {
        return "Show the object internals: field layout and default contents, object header";
    }

    @Override
    public void run(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected one or more class names.");
            return;
        }
        System.out.println(VMSupport.vmDetails());
        for (String klassName : args) {
            try {
                Class<?> klass = Class.forName(klassName);
                try {
                    Constructor<?> ctor = klass.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    Object o = klass.newInstance();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable(o));
                }
                catch (NoSuchMethodException e) {
                    System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
                    System.out.println();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable());
                }
                catch (IllegalAccessException e) {
                    System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
                    System.out.println();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable());
                }
                catch (InstantiationException e) {
                    System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
                    System.out.println();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable());
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }
}

