/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.io.File;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.X86_32_DataModel;
import org.openjdk.jol.datamodel.X86_64_COOPS_DataModel;
import org.openjdk.jol.datamodel.X86_64_DataModel;
import org.openjdk.jol.heap.HeapDumpReader;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.layouters.RawLayouter;
import org.openjdk.jol.util.Multiset;

public class MainHeapDump {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: jol-heapdump.jar [heapdump.hprof]");
            System.exit(1);
        }
        String path = args[0];
        System.out.println("Heap Dump: " + path);
        System.out.println("Estimated heap consumed, bytes:");
        HeapDumpReader reader = new HeapDumpReader(new File(path));
        Multiset data = reader.parse();
        for (DataModel model : new DataModel[]{new X86_32_DataModel(), new X86_64_DataModel(), new X86_64_COOPS_DataModel()}) {
            RawLayouter l = new RawLayouter(model);
            long rawData = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%11s %,15d: %s%n", "", rawData, l);
            l = new HotSpotLayouter(model, false, false, false);
            long hsBase = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%11s %,15d: %s%n", "", hsBase, l);
            l = new HotSpotLayouter(model, true, false, false);
            long s = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%10.3f%% %,15d: %s%n", (double)(s - hsBase) * 100.0 / (double)hsBase, s, l);
            l = new HotSpotLayouter(model, false, true, false);
            s = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%10.3f%% %,15d: %s%n", (double)(s - hsBase) * 100.0 / (double)hsBase, s, l);
            l = new HotSpotLayouter(model, false, false, true);
            s = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%10.3f%% %,15d: %s%n", (double)(s - hsBase) * 100.0 / (double)hsBase, s, l);
            l = new HotSpotLayouter(model, true, false, true);
            s = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%10.3f%% %,15d: %s%n", (double)(s - hsBase) * 100.0 / (double)hsBase, s, l);
            l = new HotSpotLayouter(model, false, true, true);
            s = MainHeapDump.process((Multiset<ClassData>)data, (Layouter)l);
            System.out.printf("%10.3f%% %,15d: %s%n", (double)(s - hsBase) * 100.0 / (double)hsBase, s, l);
            System.out.println();
        }
    }

    static long process(Multiset<ClassData> data, Layouter layouter) {
        long totalFootprint = 0L;
        for (ClassData cd : data.keys()) {
            ClassLayout layout = layouter.layout(cd);
            totalFootprint += (long)(layout.instanceSize() * data.count((Object)cd));
        }
        return totalFootprint;
    }
}

