/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jol.info.GraphLayout;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class LinkedChainBench {
    @Param(value={"1000"})
    private int size;
    Node linkedChain;

    @Setup
    public void setup() {
        this.linkedChain = new Node(null);
        for (int c = 0; c < this.size; ++c) {
            this.linkedChain = new Node(this.linkedChain);
        }
    }

    @Benchmark
    public long linkedChain() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.linkedChain}).totalSize();
    }

    public static class Node {
        Node n;

        Node(Node n) {
            this.n = n;
        }
    }
}

