/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=5)
@State(value=Scope.Benchmark)
public class JMHSample_37_CacheAccess {
    private static final int COUNT = 4096;
    private static final int MATRIX_SIZE = 0x1000000;
    private int[][] matrix;

    @Setup
    public void setup() {
        this.matrix = new int[4096][4096];
        Random random = new Random(1234L);
        for (int i = 0; i < 4096; ++i) {
            for (int j = 0; j < 4096; ++j) {
                this.matrix[i][j] = random.nextInt();
            }
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=0x1000000)
    public void colFirst(Blackhole bh) {
        for (int c = 0; c < 4096; ++c) {
            for (int r = 0; r < 4096; ++r) {
                bh.consume(this.matrix[r][c]);
            }
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=0x1000000)
    public void rowFirst(Blackhole bh) {
        for (int r = 0; r < 4096; ++r) {
            for (int c = 0; c < 4096; ++c) {
                bh.consume(this.matrix[r][c]);
            }
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_37_CacheAccess.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

