/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=5)
public class JMHSample_22_FalseSharing {
    @Benchmark
    @Group(value="baseline")
    public int reader(StateBaseline s) {
        return s.readOnly;
    }

    @Benchmark
    @Group(value="baseline")
    public void writer(StateBaseline s) {
        ++s.writeOnly;
    }

    @Benchmark
    @Group(value="padded")
    public int reader(StatePadded s) {
        return s.readOnly;
    }

    @Benchmark
    @Group(value="padded")
    public void writer(StatePadded s) {
        ++s.writeOnly;
    }

    @Benchmark
    @Group(value="hierarchy")
    public int reader(StateHierarchy s) {
        return s.readOnly;
    }

    @Benchmark
    @Group(value="hierarchy")
    public void writer(StateHierarchy s) {
        ++s.writeOnly;
    }

    @Benchmark
    @Group(value="sparse")
    public int reader(StateArray s) {
        return s.arr[0];
    }

    @Benchmark
    @Group(value="sparse")
    public void writer(StateArray s) {
        s.arr[64] = s.arr[64] + 1;
    }

    @Benchmark
    @Group(value="contended")
    public int reader(StateContended s) {
        return s.readOnly;
    }

    @Benchmark
    @Group(value="contended")
    public void writer(StateContended s) {
        ++s.writeOnly;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_22_FalseSharing.class.getSimpleName()).threads(Runtime.getRuntime().availableProcessors()).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Group)
    public static class StateContended {
        int readOnly;
        int writeOnly;
    }

    @State(value=Scope.Group)
    public static class StateArray {
        int[] arr = new int[128];
    }

    @State(value=Scope.Group)
    public static class StateHierarchy
    extends StateHierarchy_4 {
    }

    public static class StateHierarchy_4
    extends StateHierarchy_3 {
        byte q01;
        byte q02;
        byte q03;
        byte q04;
        byte q05;
        byte q06;
        byte q07;
        byte q08;
        byte q11;
        byte q12;
        byte q13;
        byte q14;
        byte q15;
        byte q16;
        byte q17;
        byte q18;
        byte q21;
        byte q22;
        byte q23;
        byte q24;
        byte q25;
        byte q26;
        byte q27;
        byte q28;
        byte q31;
        byte q32;
        byte q33;
        byte q34;
        byte q35;
        byte q36;
        byte q37;
        byte q38;
        byte q41;
        byte q42;
        byte q43;
        byte q44;
        byte q45;
        byte q46;
        byte q47;
        byte q48;
        byte q51;
        byte q52;
        byte q53;
        byte q54;
        byte q55;
        byte q56;
        byte q57;
        byte q58;
        byte q61;
        byte q62;
        byte q63;
        byte q64;
        byte q65;
        byte q66;
        byte q67;
        byte q68;
        byte q71;
        byte q72;
        byte q73;
        byte q74;
        byte q75;
        byte q76;
        byte q77;
        byte q78;
    }

    public static class StateHierarchy_3
    extends StateHierarchy_2 {
        int writeOnly;
    }

    public static class StateHierarchy_2
    extends StateHierarchy_1 {
        byte p01;
        byte p02;
        byte p03;
        byte p04;
        byte p05;
        byte p06;
        byte p07;
        byte p08;
        byte p11;
        byte p12;
        byte p13;
        byte p14;
        byte p15;
        byte p16;
        byte p17;
        byte p18;
        byte p21;
        byte p22;
        byte p23;
        byte p24;
        byte p25;
        byte p26;
        byte p27;
        byte p28;
        byte p31;
        byte p32;
        byte p33;
        byte p34;
        byte p35;
        byte p36;
        byte p37;
        byte p38;
        byte p41;
        byte p42;
        byte p43;
        byte p44;
        byte p45;
        byte p46;
        byte p47;
        byte p48;
        byte p51;
        byte p52;
        byte p53;
        byte p54;
        byte p55;
        byte p56;
        byte p57;
        byte p58;
        byte p61;
        byte p62;
        byte p63;
        byte p64;
        byte p65;
        byte p66;
        byte p67;
        byte p68;
        byte p71;
        byte p72;
        byte p73;
        byte p74;
        byte p75;
        byte p76;
        byte p77;
        byte p78;
    }

    public static class StateHierarchy_1 {
        int readOnly;
    }

    @State(value=Scope.Group)
    public static class StatePadded {
        int readOnly;
        int p01;
        int p02;
        int p03;
        int p04;
        int p05;
        int p06;
        int p07;
        int p08;
        int p11;
        int p12;
        int p13;
        int p14;
        int p15;
        int p16;
        int p17;
        int p18;
        int writeOnly;
        int q01;
        int q02;
        int q03;
        int q04;
        int q05;
        int q06;
        int q07;
        int q08;
        int q11;
        int q12;
        int q13;
        int q14;
        int q15;
        int q16;
        int q17;
        int q18;
    }

    @State(value=Scope.Group)
    public static class StateBaseline {
        int readOnly;
        int writeOnly;
    }
}

