/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class JMHSample_11_Loops {
    int x = 1;
    int y = 2;

    @Benchmark
    public int measureRight() {
        return this.x + this.y;
    }

    private int reps(int reps) {
        int s = 0;
        for (int i = 0; i < reps; ++i) {
            s += this.x + this.y;
        }
        return s;
    }

    @Benchmark
    @OperationsPerInvocation(value=1)
    public int measureWrong_1() {
        return this.reps(1);
    }

    @Benchmark
    @OperationsPerInvocation(value=10)
    public int measureWrong_10() {
        return this.reps(10);
    }

    @Benchmark
    @OperationsPerInvocation(value=100)
    public int measureWrong_100() {
        return this.reps(100);
    }

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public int measureWrong_1000() {
        return this.reps(1000);
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public int measureWrong_10000() {
        return this.reps(10000);
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public int measureWrong_100000() {
        return this.reps(100000);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_11_Loops.class.getSimpleName()).warmupIterations(5).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }
}

