/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=5)
@State(value=Scope.Benchmark)
public class JMHSample_36_BranchPrediction {
    private static final int COUNT = 0x100000;
    private byte[] sorted;
    private byte[] unsorted;

    @Setup
    public void setup() {
        this.sorted = new byte[0x100000];
        this.unsorted = new byte[0x100000];
        Random random = new Random(1234L);
        random.nextBytes(this.sorted);
        random.nextBytes(this.unsorted);
        Arrays.sort(this.sorted);
    }

    @Benchmark
    @OperationsPerInvocation(value=0x100000)
    public void sorted(Blackhole bh1, Blackhole bh2) {
        for (byte v : this.sorted) {
            if (v > 0) {
                bh1.consume(v);
                continue;
            }
            bh2.consume(v);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=0x100000)
    public void unsorted(Blackhole bh1, Blackhole bh2) {
        for (byte v : this.unsorted) {
            if (v > 0) {
                bh1.consume(v);
                continue;
            }
            bh2.consume(v);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_36_BranchPrediction.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

