/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class JMHSample_07_FixtureLevelInvocation {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public double measureHot(NormalState e, Scratch s) throws ExecutionException, InterruptedException {
        return e.service.submit(new Task(s)).get();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public double measureCold(LaggingState e, Scratch s) throws ExecutionException, InterruptedException {
        return e.service.submit(new Task(s)).get();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_07_FixtureLevelInvocation.class.getSimpleName()).warmupIterations(5).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    public static class Task
    implements Callable<Double> {
        private Scratch s;

        public Task(Scratch s) {
            this.s = s;
        }

        @Override
        public Double call() {
            return this.s.doWork();
        }
    }

    @State(value=Scope.Thread)
    public static class Scratch {
        private double p;

        public double doWork() {
            this.p = Math.log(this.p);
            return this.p;
        }
    }

    public static class LaggingState
    extends NormalState {
        public static final int SLEEP_TIME = Integer.getInteger("sleepTime", 10);

        @Setup(value=Level.Invocation)
        public void lag() throws InterruptedException {
            TimeUnit.MILLISECONDS.sleep(SLEEP_TIME);
        }
    }

    @State(value=Scope.Benchmark)
    public static class NormalState {
        ExecutorService service;

        @Setup(value=Level.Trial)
        public void up() {
            this.service = Executors.newCachedThreadPool();
        }

        @TearDown(value=Level.Trial)
        public void down() {
            this.service.shutdown();
        }
    }
}

