/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
public class JMHSample_05_StateFixtures {
    double x;

    @Setup
    public void prepare() {
        this.x = Math.PI;
    }

    @TearDown
    public void check() {
        assert (this.x > Math.PI) : "Nothing changed?";
    }

    @Benchmark
    public void measureRight() {
        this.x += 1.0;
    }

    @Benchmark
    public void measureWrong() {
        double x = 0.0;
        x += 1.0;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_05_StateFixtures.class.getSimpleName()).warmupIterations(5).measurementIterations(5).forks(1).jvmArgs(new String[]{"-ea"}).build();
        new Runner(opt).run();
    }
}

