/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.LinkedList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
public class JMHSample_26_BatchSize {
    List<String> list = new LinkedList<String>();

    @Benchmark
    @Warmup(iterations=5, time=1)
    @Measurement(iterations=5, time=1)
    @BenchmarkMode(value={Mode.AverageTime})
    public List<String> measureWrong_1() {
        this.list.add(this.list.size() / 2, "something");
        return this.list;
    }

    @Benchmark
    @Warmup(iterations=5, time=5)
    @Measurement(iterations=5, time=5)
    @BenchmarkMode(value={Mode.AverageTime})
    public List<String> measureWrong_5() {
        this.list.add(this.list.size() / 2, "something");
        return this.list;
    }

    @Benchmark
    @Warmup(iterations=5, batchSize=5000)
    @Measurement(iterations=5, batchSize=5000)
    @BenchmarkMode(value={Mode.SingleShotTime})
    public List<String> measureRight() {
        this.list.add(this.list.size() / 2, "something");
        return this.list;
    }

    @Setup(value=Level.Iteration)
    public void setup() {
        this.list.clear();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_26_BatchSize.class.getSimpleName() + ".*").forks(1).build();
        new Runner(opt).run();
    }
}

