/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.asm;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.openjdk.jmh.generators.asm.ASMClassInfo;
import org.openjdk.jmh.generators.asm.AnnotationInvocationHandler;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;

class ASMFieldInfo
extends FieldVisitor
implements FieldInfo {
    private final ClassInfo type;
    private final ASMClassInfo declaringClass;
    private final int access;
    private final String name;
    private final Map<String, AnnotationInvocationHandler> annotations;

    public ASMFieldInfo(FieldVisitor fieldVisitor, ASMClassInfo declaringClass, int access, String name, ClassInfo type) {
        super(262144, fieldVisitor);
        this.declaringClass = declaringClass;
        this.access = access;
        this.name = name;
        this.type = type;
        this.annotations = new HashMap<String, AnnotationInvocationHandler>();
    }

    public String getName() {
        return this.name;
    }

    public ClassInfo getType() {
        return this.type;
    }

    public boolean isPublic() {
        return (this.access & 1) > 0;
    }

    public boolean isStatic() {
        return (this.access & 8) > 0;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        AnnotationInvocationHandler handler = this.annotations.get(annClass.getCanonicalName());
        if (handler == null) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{annClass}, (InvocationHandler)handler));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType((String)desc).getClassName();
        AnnotationInvocationHandler annHandler = new AnnotationInvocationHandler(className, super.visitAnnotation(desc, visible));
        this.annotations.put(className, annHandler);
        return annHandler;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        return this.declaringClass.getQualifiedName() + "." + this.name;
    }
}

