/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.openjdk.jmh.generators.asm.ASMClassInfo;
import org.openjdk.jmh.generators.asm.ClassInfoRepo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.util.FileUtils;

public class ASMGeneratorSource
implements GeneratorSource {
    private final ClassInfoRepo classInfos = new ClassInfoRepo();

    public void processClasses(Collection<File> classFiles) throws IOException {
        for (File f : classFiles) {
            this.processClass(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClass(File classFile) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(classFile);
            this.processClass(fis);
        }
        catch (Throwable throwable) {
            FileUtils.safelyClose(fis);
            throw throwable;
        }
        FileUtils.safelyClose((InputStream)fis);
    }

    public void processClass(InputStream stream) throws IOException {
        ASMClassInfo ci = new ASMClassInfo(this.classInfos);
        ClassReader reader = new ClassReader(stream);
        reader.accept((ClassVisitor)ci, 0);
        this.classInfos.put(ci.getIdName(), ci);
    }

    public Collection<ClassInfo> getClasses() {
        return this.classInfos.getInfos();
    }

    public ClassInfo resolveClass(String className) {
        return this.classInfos.get(className);
    }
}

