/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.asm;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openjdk.jmh.generators.asm.ASMFieldInfo;
import org.openjdk.jmh.generators.asm.ASMMethodInfo;
import org.openjdk.jmh.generators.asm.AnnotationInvocationHandler;
import org.openjdk.jmh.generators.asm.ClassInfoRepo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.MethodInfo;

class ASMClassInfo
extends ClassVisitor
implements ClassInfo {
    private String idName;
    private String packageName;
    private String qualifiedName;
    private String name;
    private int access;
    private final List<MethodInfo> methods;
    private final List<MethodInfo> constructors;
    private final List<FieldInfo> fields;
    private final Map<String, AnnotationInvocationHandler> annotations = new HashMap<String, AnnotationInvocationHandler>();
    private final ClassInfoRepo classInfos;
    private String superName;
    private String declaringClass;
    private boolean isInner;
    private String origQualifiedName;

    public ASMClassInfo(ClassInfoRepo classInfos) {
        super(262144);
        this.classInfos = classInfos;
        this.methods = new ArrayList<MethodInfo>();
        this.constructors = new ArrayList<MethodInfo>();
        this.fields = new ArrayList<FieldInfo>();
    }

    public String getIdName() {
        return this.idName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
        this.idName = name;
        this.access = access;
        this.qualifiedName = name.replace("/", ".");
        this.packageName = this.qualifiedName.substring(0, this.qualifiedName.lastIndexOf("."));
        this.origQualifiedName = this.qualifiedName;
        this.qualifiedName = this.qualifiedName.replace('$', '.');
        this.name = this.qualifiedName.substring(this.qualifiedName.lastIndexOf(".") + 1);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        AnnotationInvocationHandler handler = this.annotations.get(annClass.getCanonicalName());
        if (handler == null) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{annClass}, (InvocationHandler)handler));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationInvocationHandler annHandler = new AnnotationInvocationHandler(super.visitAnnotation(desc, visible));
        this.annotations.put(Type.getType((String)desc).getClassName(), annHandler);
        return annHandler;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        ClassInfo type = this.classInfos.get(Type.getReturnType((String)desc).getClassName());
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        ASMFieldInfo fi = new ASMFieldInfo(fv, this, access, name, type);
        this.fields.add(fi);
        return fi;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        ASMMethodInfo mi = new ASMMethodInfo(super.visitMethod(access, methodName, methodDesc, signature, exceptions), this.classInfos, this, access, methodName, methodDesc, signature);
        this.methods.add(mi);
        if (methodName.equals("<init>")) {
            this.constructors.add(mi);
        }
        return mi;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public Collection<FieldInfo> getFields() {
        return this.fields;
    }

    public Collection<MethodInfo> getConstructors() {
        return this.constructors;
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods;
    }

    public ClassInfo getSuperClass() {
        return this.classInfos.get(this.superName);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.idName)) {
            this.declaringClass = outerName;
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.isInner = true;
    }

    public ClassInfo getDeclaringClass() {
        if (this.declaringClass != null) {
            return this.classInfos.get(this.declaringClass);
        }
        return null;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) > 0;
    }

    public boolean isPublic() {
        return (this.access & 1) > 0;
    }

    public boolean isStrictFP() {
        return (this.access & 0x800) > 0;
    }

    public boolean isFinal() {
        return (this.access & 0x10) > 0;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public boolean isEnum() {
        return (this.access & 0x4000) > 0;
    }

    public Collection<String> getEnumConstants() {
        if (this.isEnum()) {
            try {
                ArrayList<String> res = new ArrayList<String>();
                for (Object cnst : Class.forName(this.origQualifiedName, false, Thread.currentThread().getContextClassLoader()).getEnumConstants()) {
                    res.add(cnst.toString());
                }
                return res;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Can not find and instantiate enum: " + this.origQualifiedName);
            }
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.qualifiedName;
    }
}

