/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.test.mock.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.test.mock.item.AttributeDescription;
import org.openjdk.jmc.test.mock.item.MockAttributes;
import org.openjdk.jmc.test.mock.item.MockItem;

public class MockNumberType
implements IType<MockItem<Number, MockNumberType>> {
    private final Map<IAccessorKey<?>, AttributeDescription> keys = new HashMap();
    private final List<IAttribute<?>> attributes = new ArrayList();

    public MockNumberType() {
        IAccessorKey accessorKey = (IAccessorKey)Attribute.attr((String)"mock/doubletype", (ContentType)UnitLookup.NUMBER);
        this.keys.put(accessorKey, new AttributeDescription(MockAttributes.DOUBLE_VALUE));
        accessorKey = (IAccessorKey)Attribute.attr((String)"mock/index", (ContentType)UnitLookup.NUMBER);
        this.keys.put(accessorKey, new AttributeDescription(MockAttributes.INDEX_VALUE));
        this.attributes.add(MockAttributes.DOUBLE_VALUE);
        this.attributes.add(MockAttributes.INDEX_VALUE);
    }

    public String getName() {
        return "Mock Double";
    }

    public String getDescription() {
        return "Event type with a double value and a long index";
    }

    public List<IAttribute<?>> getAttributes() {
        return this.attributes;
    }

    public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
        return this.keys;
    }

    public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
        return attribute.getAccessor((IType)this) != null;
    }

    public <M> IMemberAccessor<M, MockItem<Number, MockNumberType>> getAccessor(IAccessorKey<M> attribute) {
        if (attribute.getIdentifier().equals("mock/index")) {
            return new IMemberAccessor<IQuantity, MockItem<Number, MockNumberType>>(){

                public IQuantity getMember(MockItem<Number, MockNumberType> inObject) {
                    return UnitLookup.NUMBER_UNITY.quantity((Number)inObject.getIndex());
                }
            };
        }
        if (attribute.getIdentifier().equals("mock/doubletype")) {
            return new IMemberAccessor<IQuantity, MockItem<Number, MockNumberType>>(){

                public IQuantity getMember(MockItem<Number, MockNumberType> inObject) {
                    return UnitLookup.NUMBER_UNITY.quantity(inObject.getValue());
                }
            };
        }
        throw new UnsupportedOperationException("Not supported by the testing framwork.");
    }

    public String getIdentifier() {
        return "mock/MockNumberItem";
    }
}

