/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;
import org.openjdk.jmc.test.TestToolkit;
import org.openjdk.jmc.test.io.IOResource;
import org.openjdk.jmc.test.io.IOResourceSet;

public class RecordingToolkit {
    static final String RECORDING_TEXT_FILE_CHARSET = "UTF-8";
    private static final String RECORDINGS_DIRECTORY = "recordings";
    private static final String RECORDINGS_INDEXFILE = "index.txt";

    public static File getRecordingDirectory() throws IOException {
        return TestToolkit.getProjectDirectory(RecordingToolkit.class, RECORDINGS_DIRECTORY);
    }

    public static IOResourceSet getRecordings() throws IOException {
        return TestToolkit.getResourcesInDirectory(RecordingToolkit.class, RECORDINGS_DIRECTORY, RECORDINGS_INDEXFILE);
    }

    public static IItemCollection getNamedRecording(String recordingName) throws IOException, CouldNotLoadRecordingException {
        return RecordingToolkit.getFlightRecording(TestToolkit.getNamedResource(RecordingToolkit.class, RECORDINGS_DIRECTORY, recordingName));
    }

    public static InputStream getNamedRecordingResource(String recordingName) throws IOException {
        return TestToolkit.getNamedResource(RecordingToolkit.class, RECORDINGS_DIRECTORY, recordingName).open();
    }

    public static IItemCollection getFlightRecording(IOResourceSet resourceSet) throws IOException, CouldNotLoadRecordingException {
        return RecordingToolkit.getFlightRecording(resourceSet.getResource(0));
    }

    public static IItemCollection getFlightRecording(IOResource resource) throws IOException, CouldNotLoadRecordingException {
        return RecordingToolkit.getFlightRecording(resource, ParserExtensionRegistry.getParserExtensions());
    }

    public static IItemCollection getFlightRecording(IOResource resource, List<IParserExtension> extensions) throws IOException, CouldNotLoadRecordingException {
        File tmpRecording = RecordingToolkit.createResultFile("recordingTest", "tmp_recording", true);
        InputStream is = resource.open();
        FileOutputStream os = new FileOutputStream(tmpRecording);
        int read = 0;
        byte[] tmp = new byte[4096];
        while ((read = is.read(tmp)) > 0) {
            ((OutputStream)os).write(tmp, 0, read);
        }
        IOToolkit.closeSilently((Closeable)os);
        IOToolkit.closeSilently((Closeable)is);
        return JfrLoaderToolkit.loadEvents(Arrays.asList(tmpRecording), extensions);
    }

    public static List<String> getStats(IOResourceSet resourceSet) throws IOException {
        IOResource resource = resourceSet.getResource(0);
        String recordingFileName = resource.getName();
        String statsFileName = recordingFileName.replace(".jfr", ".txt");
        IOResource statsResource = TestToolkit.getNamedResource(RecordingToolkit.class, "stats", statsFileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(statsResource.open()));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static File createResultFile(String prefix, String suffix, boolean deleteTempOnExit) throws IOException {
        File resultFile;
        String resultDir = System.getProperty("results.dir");
        if (resultDir != null) {
            resultFile = new File(resultDir, prefix + "." + System.currentTimeMillis() + "." + suffix);
        } else {
            resultFile = File.createTempFile(prefix, suffix);
            if (deleteTempOnExit) {
                resultFile.deleteOnExit();
            }
        }
        return resultFile;
    }
}

